/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.StoreException;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.constants.DBType;
import io.seata.core.store.db.DataSourceGenerator;

public abstract class AbstractDataSourceGenerator
implements DataSourceGenerator {
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();

    protected DBType getDBType() {
        return DBType.valueof(CONFIG.getConfig("store.db.db-type"));
    }

    protected String getUrl() {
        String url = CONFIG.getConfig("store.db.url");
        if (StringUtils.isBlank((String)url)) {
            throw new StoreException("the {store.db.url} can't empty.");
        }
        return url;
    }

    protected String getUser() {
        String user = CONFIG.getConfig("store.db.user");
        if (StringUtils.isBlank((String)user)) {
            throw new StoreException("the {store.db.user} can't empty.");
        }
        return user;
    }

    protected String getPassword() {
        String password = CONFIG.getConfig("store.db.password");
        return password;
    }

    protected int getMinConn() {
        int minConn = CONFIG.getInt("store.db.min-conn");
        return minConn < 0 ? 0 : minConn;
    }

    protected int getMaxConn() {
        int maxConn = CONFIG.getInt("store.db.max-conn");
        return maxConn < 0 ? 1 : maxConn;
    }

    protected static String getDriverName(DBType dbType) {
        if (DBType.H2.equals((Object)dbType)) {
            return "org.h2.Driver";
        }
        if (DBType.MYSQL.equals((Object)dbType)) {
            return "com.mysql.jdbc.Driver";
        }
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "oracle.jdbc.OracleDriver";
        }
        if (DBType.SYBAEE.equals((Object)dbType)) {
            return "com.sybase.jdbc2.jdbc.SybDriver";
        }
        if (DBType.SQLSERVER.equals((Object)dbType)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (DBType.SQLITE.equals((Object)dbType)) {
            return "org.sqlite.JDBC";
        }
        if (DBType.POSTGRESQL.equals((Object)dbType)) {
            return "org.postgresql.Driver";
        }
        if (DBType.ACCESS.equals((Object)dbType)) {
            return "com.hxtt.sql.access.AccessDriver";
        }
        if (DBType.DB2.equals((Object)dbType)) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        throw new StoreException("Unsupported database type, dbType:" + (Object)((Object)dbType));
    }

    protected String getValidationQuery(DBType dbType) {
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "select sysdate from dual";
        }
        return "select 1";
    }
}

