/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc;

import io.seata.core.rpc.Disposable;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHook.class);
    private static final ShutdownHook SHUTDOWN_HOOK = new ShutdownHook("ShutdownHook");
    private final PriorityQueue<DisposablePriorityWrapper> disposables = new PriorityQueue();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private static final int DEFAULT_PRIORITY = 10;

    private ShutdownHook(String name) {
        super(name);
    }

    public static ShutdownHook getInstance() {
        return SHUTDOWN_HOOK;
    }

    public void addDisposable(Disposable disposable) {
        this.addDisposable(disposable, 10);
    }

    public void addDisposable(Disposable disposable, int priority) {
        this.disposables.add(new DisposablePriorityWrapper(disposable, priority));
    }

    @Override
    public void run() {
        this.destroyAll();
    }

    public void destroyAll() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        if (this.disposables.isEmpty()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destroyAll starting");
        }
        while (!this.disposables.isEmpty()) {
            Disposable disposable = this.disposables.poll();
            disposable.destroy();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destroyAll finish");
        }
    }

    public static void removeRuntimeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
    }

    static {
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
    }

    private static class DisposablePriorityWrapper
    implements Comparable<DisposablePriorityWrapper>,
    Disposable {
        private final Disposable disposable;
        private final int priority;

        public DisposablePriorityWrapper(Disposable disposable, int priority) {
            this.disposable = disposable;
            this.priority = priority;
        }

        @Override
        public int compareTo(DisposablePriorityWrapper challenger) {
            return this.priority - challenger.priority;
        }

        @Override
        public void destroy() {
            this.disposable.destroy();
        }
    }
}

