/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.serializer;

import io.seata.core.protocol.MergeResultMessage;
import io.seata.core.protocol.MergedWarpMessage;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.protocol.RegisterRMResponse;
import io.seata.core.protocol.RegisterTMRequest;
import io.seata.core.protocol.RegisterTMResponse;
import io.seata.core.protocol.transaction.BranchCommitRequest;
import io.seata.core.protocol.transaction.BranchCommitResponse;
import io.seata.core.protocol.transaction.BranchRegisterRequest;
import io.seata.core.protocol.transaction.BranchRegisterResponse;
import io.seata.core.protocol.transaction.BranchReportRequest;
import io.seata.core.protocol.transaction.BranchReportResponse;
import io.seata.core.protocol.transaction.BranchRollbackRequest;
import io.seata.core.protocol.transaction.BranchRollbackResponse;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.protocol.transaction.GlobalCommitRequest;
import io.seata.core.protocol.transaction.GlobalCommitResponse;
import io.seata.core.protocol.transaction.GlobalLockQueryRequest;
import io.seata.core.protocol.transaction.GlobalLockQueryResponse;
import io.seata.core.protocol.transaction.GlobalReportRequest;
import io.seata.core.protocol.transaction.GlobalReportResponse;
import io.seata.core.protocol.transaction.GlobalRollbackRequest;
import io.seata.core.protocol.transaction.GlobalRollbackResponse;
import io.seata.core.protocol.transaction.GlobalStatusRequest;
import io.seata.core.protocol.transaction.GlobalStatusResponse;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SerializerClassRegistry {
    private static final Map<Class<?>, Object> REGISTRATIONS = new LinkedHashMap();

    public static void registerClass(Class<?> clazz) {
        SerializerClassRegistry.registerClass(clazz, null);
    }

    public static void registerClass(Class<?> clazz, Object serializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class registered cannot be null!");
        }
        REGISTRATIONS.put(clazz, serializer);
    }

    public static Map<Class<?>, Object> getRegisteredClasses() {
        return REGISTRATIONS;
    }

    static {
        SerializerClassRegistry.registerClass(HashMap.class);
        SerializerClassRegistry.registerClass(ArrayList.class);
        SerializerClassRegistry.registerClass(LinkedList.class);
        SerializerClassRegistry.registerClass(HashSet.class);
        SerializerClassRegistry.registerClass(TreeSet.class);
        SerializerClassRegistry.registerClass(Hashtable.class);
        SerializerClassRegistry.registerClass(Date.class);
        SerializerClassRegistry.registerClass(Calendar.class);
        SerializerClassRegistry.registerClass(ConcurrentHashMap.class);
        SerializerClassRegistry.registerClass(SimpleDateFormat.class);
        SerializerClassRegistry.registerClass(GregorianCalendar.class);
        SerializerClassRegistry.registerClass(Vector.class);
        SerializerClassRegistry.registerClass(BitSet.class);
        SerializerClassRegistry.registerClass(StringBuffer.class);
        SerializerClassRegistry.registerClass(StringBuilder.class);
        SerializerClassRegistry.registerClass(Object.class);
        SerializerClassRegistry.registerClass(Object[].class);
        SerializerClassRegistry.registerClass(String[].class);
        SerializerClassRegistry.registerClass(byte[].class);
        SerializerClassRegistry.registerClass(char[].class);
        SerializerClassRegistry.registerClass(int[].class);
        SerializerClassRegistry.registerClass(float[].class);
        SerializerClassRegistry.registerClass(double[].class);
        SerializerClassRegistry.registerClass(BranchCommitRequest.class);
        SerializerClassRegistry.registerClass(BranchCommitResponse.class);
        SerializerClassRegistry.registerClass(BranchRegisterRequest.class);
        SerializerClassRegistry.registerClass(BranchRegisterResponse.class);
        SerializerClassRegistry.registerClass(BranchReportRequest.class);
        SerializerClassRegistry.registerClass(BranchReportResponse.class);
        SerializerClassRegistry.registerClass(BranchRollbackRequest.class);
        SerializerClassRegistry.registerClass(BranchRollbackResponse.class);
        SerializerClassRegistry.registerClass(GlobalBeginRequest.class);
        SerializerClassRegistry.registerClass(GlobalBeginResponse.class);
        SerializerClassRegistry.registerClass(GlobalCommitRequest.class);
        SerializerClassRegistry.registerClass(GlobalCommitResponse.class);
        SerializerClassRegistry.registerClass(GlobalLockQueryRequest.class);
        SerializerClassRegistry.registerClass(GlobalLockQueryResponse.class);
        SerializerClassRegistry.registerClass(GlobalRollbackRequest.class);
        SerializerClassRegistry.registerClass(GlobalRollbackResponse.class);
        SerializerClassRegistry.registerClass(GlobalStatusRequest.class);
        SerializerClassRegistry.registerClass(GlobalStatusResponse.class);
        SerializerClassRegistry.registerClass(UndoLogDeleteRequest.class);
        SerializerClassRegistry.registerClass(GlobalReportRequest.class);
        SerializerClassRegistry.registerClass(GlobalReportResponse.class);
        SerializerClassRegistry.registerClass(MergedWarpMessage.class);
        SerializerClassRegistry.registerClass(MergeResultMessage.class);
        SerializerClassRegistry.registerClass(RegisterRMRequest.class);
        SerializerClassRegistry.registerClass(RegisterRMResponse.class);
        SerializerClassRegistry.registerClass(RegisterTMRequest.class);
        SerializerClassRegistry.registerClass(RegisterTMResponse.class);
    }
}

