/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryProvider;
import io.seata.discovery.registry.RegistryService;
import io.seata.discovery.registry.RegistryType;
import java.util.Objects;

public class RegistryFactory {
    public static RegistryService getInstance() {
        return RegistryFactoryHolder.INSTANCE;
    }

    private static RegistryService buildRegistryService() {
        RegistryType registryType;
        String registryTypeName = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig("registry.type");
        try {
            registryType = RegistryType.getType(registryTypeName);
        }
        catch (Exception exx) {
            throw new NotSupportYetException("not support registry type: " + registryTypeName);
        }
        return ((RegistryProvider)EnhancedServiceLoader.load(RegistryProvider.class, (String)Objects.requireNonNull(registryType).name())).provide();
    }

    static /* synthetic */ RegistryService access$100() {
        return RegistryFactory.buildRegistryService();
    }

    private static class RegistryFactoryHolder {
        private static final RegistryService INSTANCE = RegistryFactory.access$100();

        private RegistryFactoryHolder() {
        }
    }
}

