/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry.compact;

import io.seata.metrics.Clock;
import io.seata.metrics.Counter;
import io.seata.metrics.Id;
import io.seata.metrics.Measurement;
import io.seata.metrics.SystemClock;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class CompactCounter
implements Counter {
    private final Id id;
    private final AtomicLong counter;
    private final Clock clock;

    public CompactCounter(Id id) {
        this(id, SystemClock.INSTANCE);
    }

    public CompactCounter(Id id, Clock clock) {
        this.id = id;
        this.counter = new AtomicLong(0L);
        this.clock = clock;
    }

    public Id getId() {
        return this.id;
    }

    public long increase(long value) {
        return this.counter.addAndGet(value);
    }

    public long decrease(long value) {
        return this.increase(-1L * value);
    }

    public long get() {
        return this.counter.get();
    }

    public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this.id, this.clock.getCurrentMilliseconds(), (double)this.counter.get()));
    }
}

