/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry.compact;

import io.seata.metrics.Clock;
import io.seata.metrics.Gauge;
import io.seata.metrics.Id;
import io.seata.metrics.Measurement;
import io.seata.metrics.SystemClock;
import java.util.Collections;
import java.util.function.Supplier;

public class CompactGauge<T extends Number>
implements Gauge<T> {
    private final Id id;
    private final Supplier<T> supplier;
    private final Clock clock;

    public CompactGauge(Id id, Supplier<T> supplier) {
        this(id, supplier, SystemClock.INSTANCE);
    }

    public CompactGauge(Id id, Supplier<T> supplier, Clock clock) {
        this.id = id;
        this.supplier = supplier;
        this.clock = clock;
    }

    public T get() {
        return (T)((Number)this.supplier.get());
    }

    public Id getId() {
        return this.id;
    }

    public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this.id, this.clock.getCurrentMilliseconds(), ((Number)this.get()).doubleValue()));
    }
}

