/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.PreparedStatementProxy;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.SQLInsertRecognizer;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.Null;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InsertExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    protected static final String ERR_SQL_STATE = "S1009";

    public InsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        return TableRecords.empty(this.getTableMeta());
    }

    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        List<Object> pkValues = this.containsPK() ? this.getPkValuesByColumn() : this.getPkValuesByAuto();
        TableRecords afterImage = this.getTableRecords(pkValues);
        if (afterImage == null) {
            throw new SQLException("Failed to build after-image for insert");
        }
        return afterImage;
    }

    protected boolean containsPK() {
        SQLInsertRecognizer recogizier = (SQLInsertRecognizer)this.sqlRecognizer;
        List<String> insertColumns = recogizier.getInsertColumns();
        TableMeta tmeta = this.getTableMeta();
        return tmeta.containsPK(insertColumns);
    }

    protected List<Object> getPkValuesByColumn() throws SQLException {
        SQLInsertRecognizer recogizier = (SQLInsertRecognizer)this.sqlRecognizer;
        List<String> insertColumns = recogizier.getInsertColumns();
        String pk = this.getTableMeta().getPkName();
        List<Object> pkValues = null;
        for (int paramIdx = 0; paramIdx < insertColumns.size(); ++paramIdx) {
            if (!insertColumns.get(paramIdx).equalsIgnoreCase(pk)) continue;
            if (this.statementProxy instanceof PreparedStatementProxy) {
                pkValues = ((PreparedStatementProxy)this.statementProxy).getParamsByIndex(paramIdx);
                break;
            }
            List<List<Object>> insertRows = recogizier.getInsertRows();
            pkValues = new ArrayList<Object>(insertRows.size());
            for (List<Object> row : insertRows) {
                pkValues.add(row.get(paramIdx));
            }
            break;
        }
        if (pkValues == null) {
            throw new ShouldNeverHappenException();
        }
        if (pkValues.size() == 1 && pkValues.get(0) instanceof Null) {
            pkValues = this.getPkValuesByAuto();
        }
        return pkValues;
    }

    protected List<Object> getPkValuesByAuto() throws SQLException {
        Map<String, ColumnMeta> pkMetaMap = this.getTableMeta().getPrimaryKeyMap();
        if (pkMetaMap.size() != 1) {
            throw new NotSupportYetException();
        }
        ColumnMeta pkMeta = pkMetaMap.values().iterator().next();
        if (!pkMeta.isAutoincrement()) {
            throw new ShouldNeverHappenException();
        }
        ResultSet genKeys = null;
        try {
            genKeys = this.statementProxy.getTargetStatement().getGeneratedKeys();
        }
        catch (SQLException e) {
            if (ERR_SQL_STATE.equalsIgnoreCase(e.getSQLState())) {
                genKeys = this.statementProxy.getTargetStatement().executeQuery("SELECT LAST_INSERT_ID()");
            }
            throw e;
        }
        ArrayList<Object> pkValues = new ArrayList<Object>();
        while (genKeys.next()) {
            Object v = genKeys.getObject(1);
            pkValues.add(v);
        }
        return pkValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords getTableRecords(List<Object> pkValues) throws SQLException {
        TableRecords afterImage;
        String pk = this.getTableMeta().getPkName();
        StringBuffer selectSQLAppender = new StringBuffer("SELECT * FROM " + this.getTableMeta().getTableName() + " WHERE ");
        for (int i = 1; i <= pkValues.size(); ++i) {
            selectSQLAppender.append(pk + "=?");
            if (i >= pkValues.size()) continue;
            selectSQLAppender.append(" OR ");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.statementProxy.getConnection().prepareStatement(selectSQLAppender.toString());
            for (int i = 1; i <= pkValues.size(); ++i) {
                ps.setObject(i, pkValues.get(i - 1));
            }
            rs = ps.executeQuery();
            afterImage = TableRecords.buildRecords(this.getTableMeta(), rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return afterImage;
    }
}

