/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.ParametersHolder;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseTransactionalExecutor;
import io.seata.rm.datasource.exec.LockConflictException;
import io.seata.rm.datasource.exec.LockRetryController;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.SQLSelectRecognizer;
import io.seata.rm.datasource.sql.struct.TableRecords;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;

public class SelectForUpdateExecutor<S extends Statement>
extends BaseTransactionalExecutor<ResultSet, S> {
    public SelectForUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<ResultSet, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doExecute(Object ... args) throws Throwable {
        SQLSelectRecognizer recognizer = (SQLSelectRecognizer)this.sqlRecognizer;
        Connection conn = this.statementProxy.getConnection();
        ResultSet rs = null;
        Savepoint sp = null;
        LockRetryController lockRetryController = new LockRetryController();
        boolean originalAutoCommit = conn.getAutoCommit();
        StringBuffer selectSQLAppender = new StringBuffer("SELECT ");
        selectSQLAppender.append(this.getColumnNameInSQL(this.getTableMeta().getPkName()));
        selectSQLAppender.append(" FROM " + this.getFromTableInSQL());
        String whereCondition = null;
        ArrayList<Object> paramAppender = new ArrayList<Object>();
        whereCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getWhereCondition((ParametersHolder)((Object)this.statementProxy), paramAppender) : recognizer.getWhereCondition();
        if (!StringUtils.isNullOrEmpty((String)whereCondition)) {
            selectSQLAppender.append(" WHERE " + whereCondition);
        }
        selectSQLAppender.append(" FOR UPDATE");
        String selectPKSQL = selectSQLAppender.toString();
        try {
            if (originalAutoCommit) {
                conn.setAutoCommit(false);
            }
            sp = conn.setSavepoint();
            rs = (ResultSet)this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
            while (true) {
                Statement stPK = null;
                PreparedStatement pstPK = null;
                ResultSet rsPK = null;
                try {
                    if (paramAppender.isEmpty()) {
                        stPK = this.statementProxy.getConnection().createStatement();
                        rsPK = stPK.executeQuery(selectPKSQL);
                    } else {
                        pstPK = this.statementProxy.getConnection().prepareStatement(selectPKSQL);
                        for (int i = 0; i < paramAppender.size(); ++i) {
                            pstPK.setObject(i + 1, paramAppender.get(i));
                        }
                        rsPK = pstPK.executeQuery();
                    }
                    TableRecords selectPKRows = TableRecords.buildRecords(this.getTableMeta(), rsPK);
                    String lockKeys = this.buildLockKey(selectPKRows);
                    if (RootContext.inGlobalTransaction()) {
                        this.statementProxy.getConnectionProxy().checkLock(lockKeys);
                        break;
                    }
                    if (RootContext.requireGlobalLock()) {
                        this.statementProxy.getConnectionProxy().appendLockKey(lockKeys);
                        break;
                    }
                    throw new RuntimeException("Unknown situation!");
                }
                catch (LockConflictException lce) {
                    conn.rollback(sp);
                    lockRetryController.sleep(lce);
                    continue;
                }
                finally {
                    if (rsPK != null) {
                        rsPK.close();
                    }
                    if (stPK != null) {
                        stPK.close();
                    }
                    if (pstPK == null) continue;
                    pstPK.close();
                    continue;
                }
                break;
            }
        }
        finally {
            if (sp != null) {
                conn.releaseSavepoint(sp);
            }
            if (originalAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        return rs;
    }
}

