/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.evaluation;

import io.seata.common.util.StringUtils;
import io.seata.saga.engine.evaluation.EvaluatorFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EvaluatorFactoryManager {
    public static final String EVALUATOR_TYPE_DEFAULT = "Default";
    private Map<String, EvaluatorFactory> evaluatorFactoryMap = new ConcurrentHashMap<String, EvaluatorFactory>();

    public EvaluatorFactory getEvaluatorFactory(String type) {
        if (StringUtils.isBlank((String)type)) {
            type = EVALUATOR_TYPE_DEFAULT;
        }
        return this.evaluatorFactoryMap.get(type);
    }

    public Map<String, EvaluatorFactory> getEvaluatorFactoryMap() {
        return this.evaluatorFactoryMap;
    }

    public void setEvaluatorFactoryMap(Map<String, EvaluatorFactory> evaluatorFactoryMap) {
        this.evaluatorFactoryMap.putAll(evaluatorFactoryMap);
    }

    public void putEvaluatorFactory(String type, EvaluatorFactory factory) {
        this.evaluatorFactoryMap.put(type, factory);
    }
}

