/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.handlers;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.util.CollectionUtils;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.invoker.ServiceInvoker;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.CompensateSubStateMachineState;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.ServiceTaskState;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class ServiceTaskStateHandler
implements StateHandler,
InterceptableStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTaskStateHandler.class);
    private List<StateHandlerInterceptor> interceptors = new ArrayList<StateHandlerInterceptor>();

    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        ServiceTaskStateImpl state = (ServiceTaskStateImpl)instruction.getState(context);
        String serviceName = state.getServiceName();
        String methodName = state.getServiceMethod();
        StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
        try {
            Object result;
            List input = (List)context.getVariable("inputParams");
            stateInstance.setStatus(ExecutionStatus.RU);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(">>>>>>>>>>>>>>>>>>>>>> Start to execute State[{}], ServiceName[{}], Method[{}], Input:{}", new Object[]{state.getName(), serviceName, methodName, input});
            }
            if (state instanceof CompensateSubStateMachineState) {
                result = this.compensateSubStateMachine(context, (ServiceTaskState)state, input, stateInstance, (StateMachineEngine)context.getVariable("_current_statemachine_engine_"));
            } else {
                StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
                ServiceInvoker serviceInvoker = stateMachineConfig.getServiceInvokerManager().getServiceInvoker(state.getServiceType());
                if (serviceInvoker == null) {
                    throw new EngineExecutionException("No such ServiceInvoker[" + state.getServiceType() + "]", FrameworkErrorCode.ObjectNotExists);
                }
                if (serviceInvoker instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)serviceInvoker).setApplicationContext(stateMachineConfig.getApplicationContext());
                }
                result = serviceInvoker.invoke((ServiceTaskState)state, input.toArray());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("<<<<<<<<<<<<<<<<<<<<<< State[{}], ServiceName[{}], Method[{}] Execute finish. result: {}", new Object[]{state.getName(), serviceName, methodName, result});
            }
            if (result != null) {
                stateInstance.setOutputParams(result);
                ((HierarchicalProcessContext)context).setVariableLocally("outputParams", result);
            }
        }
        catch (Throwable e) {
            LOGGER.error("<<<<<<<<<<<<<<<<<<<<<< State[{}], ServiceName[{}], Method[{}] Execute failed.", new Object[]{state.getName(), serviceName, methodName, e});
            ((HierarchicalProcessContext)context).setVariableLocally("currentException", (Object)e);
            EngineUtils.handleException(context, (AbstractTaskState)state, e);
        }
    }

    private Object compensateSubStateMachine(ProcessContext context, ServiceTaskState state, Object input, StateInstance stateInstance, StateMachineEngine engine) {
        String subStateMachineParentId = (String)context.getVariable(state.getName() + "_sub_machine_parent_id_");
        if (StringUtils.isEmpty((Object)subStateMachineParentId)) {
            throw new EngineExecutionException("sub statemachine parentId is required", FrameworkErrorCode.ObjectNotExists);
        }
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        List<StateMachineInstance> subInst = stateMachineConfig.getStateLogStore().queryStateMachineInstanceByParentId(subStateMachineParentId);
        if (CollectionUtils.isEmpty(subInst)) {
            throw new EngineExecutionException("cannot find sub statemachine instance by parentId:" + subStateMachineParentId, FrameworkErrorCode.ObjectNotExists);
        }
        String subStateMachineInstId = subInst.get(0).getId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>>>>>>>>>>>>>>>>>> Start to compensate sub statemachine [id:{}]", (Object)subStateMachineInstId);
        }
        Map startParams = new HashMap(0);
        if (input instanceof List) {
            List listInputParams = (List)input;
            if (listInputParams.size() > 0) {
                startParams = (Map)listInputParams.get(0);
            }
        } else if (input instanceof Map) {
            startParams = (Map)input;
        }
        StateMachineInstance compensateInst = engine.compensate(subStateMachineInstId, startParams);
        stateInstance.setStatus(compensateInst.getCompensationStatus());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<<<<<<<<<<<<<<<<<<<<<< Compensate sub statemachine [id:{}] finished with status[{}], compensateState[{}]", new Object[]{subStateMachineInstId, compensateInst.getStatus(), compensateInst.getCompensationStatus()});
        }
        return compensateInst.getEndParams();
    }

    @Override
    public List<StateHandlerInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(StateHandlerInterceptor interceptor) {
        if (this.interceptors != null && !this.interceptors.contains(interceptor)) {
            this.interceptors.add(interceptor);
        }
    }

    public void setInterceptors(List<StateHandlerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

