/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.seata.protocol.transaction;

import io.netty.buffer.ByteBuf;
import io.seata.core.model.BranchType;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.serializer.seata.protocol.transaction.AbstractTransactionRequestToRMCodec;
import java.nio.ByteBuffer;

public class UndoLogDeleteRequestCodec
extends AbstractTransactionRequestToRMCodec {
    @Override
    public Class<?> getMessageClassType() {
        return UndoLogDeleteRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        UndoLogDeleteRequest undoLogDeleteRequest = (UndoLogDeleteRequest)t;
        short saveDays = undoLogDeleteRequest.getSaveDays();
        BranchType branchType = undoLogDeleteRequest.getBranchType();
        String resourceId = undoLogDeleteRequest.getResourceId();
        out.writeByte((int)((byte)branchType.ordinal()));
        if (resourceId != null) {
            byte[] bs = resourceId.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        out.writeShort((int)saveDays);
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        UndoLogDeleteRequest undoLogDeleteRequest = (UndoLogDeleteRequest)t;
        if (in.remaining() < 1) {
            return;
        }
        undoLogDeleteRequest.setBranchType(BranchType.get((byte)in.get()));
        if (in.remaining() < 2) {
            return;
        }
        short resourceIdLen = in.getShort();
        if (resourceIdLen <= 0 || in.remaining() < resourceIdLen) {
            return;
        }
        byte[] bs = new byte[resourceIdLen];
        in.get(bs);
        undoLogDeleteRequest.setResourceId(new String(bs, UTF8));
        if (in.remaining() < 2) {
            return;
        }
        undoLogDeleteRequest.setSaveDays(in.getShort());
    }
}

