/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.lock;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.StoreMode;
import io.seata.server.lock.LockManager;

public class LockerManagerFactory {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static volatile LockManager LOCK_MANAGER;

    public static LockManager getLockManager() {
        if (LOCK_MANAGER == null) {
            LockerManagerFactory.init();
        }
        return LOCK_MANAGER;
    }

    public static void init() {
        LockerManagerFactory.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(String lockMode) {
        if (LOCK_MANAGER != null) return;
        Class<LockerManagerFactory> clazz = LockerManagerFactory.class;
        synchronized (LockerManagerFactory.class) {
            if (LOCK_MANAGER != null) return;
            if (StringUtils.isBlank((String)lockMode)) {
                lockMode = CONFIG.getConfig("store.lock.mode", CONFIG.getConfig("store.mode", "file"));
            }
            if (!StoreMode.contains((String)lockMode)) return;
            LOCK_MANAGER = (LockManager)EnhancedServiceLoader.load(LockManager.class, (String)lockMode);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

