/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.metrics;

import io.seata.config.ConfigurationFactory;
import io.seata.metrics.exporter.ExporterFactory;
import io.seata.metrics.registry.Registry;
import io.seata.metrics.registry.RegistryFactory;
import io.seata.server.event.EventBusManager;
import io.seata.server.metrics.MetricsSubscriber;
import java.util.List;

public class MetricsManager {
    private Registry registry;

    public static final MetricsManager get() {
        return SingletonHolder.INSTANCE;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void init() {
        boolean enabled = ConfigurationFactory.getInstance().getBoolean("metrics.enabled", false);
        if (enabled) {
            List exporters;
            this.registry = RegistryFactory.getInstance();
            if (this.registry != null && (exporters = ExporterFactory.getInstanceList()).size() != 0) {
                exporters.forEach(exporter -> exporter.setRegistry(this.registry));
                EventBusManager.get().register((Object)new MetricsSubscriber(this.registry));
            }
        }
    }

    private static class SingletonHolder {
        private static MetricsManager INSTANCE = new MetricsManager();

        private SingletonHolder() {
        }
    }
}

