/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.store;

import com.google.common.collect.ImmutableMap;
import io.seata.common.XID;
import io.seata.common.exception.RedisException;
import io.seata.common.exception.StoreException;
import io.seata.common.util.BeanUtils;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.model.GlobalStatus;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.server.console.param.GlobalSessionParam;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.storage.SessionConverter;
import io.seata.server.storage.redis.JedisPooledFactory;
import io.seata.server.store.AbstractTransactionStoreManager;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.TransactionStoreManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Transaction;

public class RedisTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTransactionStoreManager.class);
    private static final String REDIS_SEATA_BRANCHES_PREFIX = "SEATA_BRANCHES_";
    private static final String REDIS_SEATA_BRANCH_PREFIX = "SEATA_BRANCH_";
    private static final String REDIS_SEATA_GLOBAL_PREFIX = "SEATA_GLOBAL_";
    private static final String REDIS_SEATA_STATUS_PREFIX = "SEATA_STATUS_";
    private static volatile RedisTransactionStoreManager instance;
    private static final String OK = "OK";
    private static final Configuration CONFIG;
    private int logQueryLimit;
    public static volatile ImmutableMap<TransactionStoreManager.LogOperation, Function<GlobalTransactionDO, Boolean>> globalMap;
    public static volatile ImmutableMap<TransactionStoreManager.LogOperation, Function<BranchTransactionDO, Boolean>> branchMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisTransactionStoreManager getInstance() {
        if (instance != null) return instance;
        Class<RedisTransactionStoreManager> clazz = RedisTransactionStoreManager.class;
        synchronized (RedisTransactionStoreManager.class) {
            if (instance != null) return instance;
            instance = new RedisTransactionStoreManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public RedisTransactionStoreManager() {
        this.initGlobalMap();
        this.initBranchMap();
        this.logQueryLimit = CONFIG.getInt("store.redis.queryLimit", 100);
        if (this.logQueryLimit > 100) {
            this.logQueryLimit = 100;
        }
    }

    public void initGlobalMap() {
        if (CollectionUtils.isEmpty(branchMap)) {
            globalMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.GLOBAL_ADD, this::insertGlobalTransactionDO).put((Object)TransactionStoreManager.LogOperation.GLOBAL_UPDATE, this::updateGlobalTransactionDO).put((Object)TransactionStoreManager.LogOperation.GLOBAL_REMOVE, this::deleteGlobalTransactionDO).build();
        }
    }

    public void initBranchMap() {
        if (CollectionUtils.isEmpty(branchMap)) {
            branchMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.BRANCH_ADD, this::insertBranchTransactionDO).put((Object)TransactionStoreManager.LogOperation.BRANCH_UPDATE, this::updateBranchTransactionDO).put((Object)TransactionStoreManager.LogOperation.BRANCH_REMOVE, this::deleteBranchTransactionDO).build();
        }
    }

    @Override
    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        if (globalMap.containsKey((Object)logOperation) || branchMap.containsKey((Object)logOperation)) {
            return globalMap.containsKey((Object)logOperation) ? ((Boolean)((Function)globalMap.get((Object)logOperation)).apply(SessionConverter.convertGlobalTransactionDO(session))).booleanValue() : ((Boolean)((Function)branchMap.get((Object)logOperation)).apply(SessionConverter.convertBranchTransactionDO(session))).booleanValue();
        }
        throw new StoreException("Unknown LogOperation:" + logOperation.name());
    }

    /*
     * Exception decompiling
     */
    private boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xid = jedis.hget(branchKey, "xid");
            if (StringUtils.isEmpty((CharSequence)xid)) {
                boolean bl = true;
                return bl;
            }
            String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
            try (Pipeline pipelined = jedis.pipelined();){
                pipelined.lrem(branchListKey, 0L, branchKey);
                pipelined.del(branchKey);
                pipelined.sync();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String previousBranchStatus = jedis.hget(branchKey, "status");
            if (StringUtils.isEmpty((CharSequence)previousBranchStatus)) {
                throw new StoreException("Branch transaction is not exist, update branch transaction failed.");
            }
            HashMap<String, String> map = new HashMap<String, String>(3, 1.0f);
            map.put("status", String.valueOf(branchTransactionDO.getStatus()));
            map.put("gmtModified", String.valueOf(new Date().getTime()));
            if (StringUtils.isNotBlank((String)branchTransactionDO.getApplicationData())) {
                map.put("applicationData", String.valueOf(branchTransactionDO.getApplicationData()));
            }
            jedis.hmset(branchKey, map);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xid = jedis.hget(globalKey, "xid");
            if (StringUtils.isEmpty((CharSequence)xid)) {
                LOGGER.warn("Global transaction is not exist,xid = {}.Maybe has been deleted by another tc server", (Object)globalTransactionDO.getXid());
                boolean bl = true;
                return bl;
            }
            try (Pipeline pipelined = jedis.pipelined();){
                pipelined.lrem(this.buildGlobalStatus(globalTransactionDO.getStatus()), 0L, globalTransactionDO.getXid());
                pipelined.del(globalKey);
                pipelined.sync();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String xid = globalTransactionDO.getXid();
        String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            jedis.watch(new String[]{globalKey});
            List statusAndGmtModified = jedis.hmget(globalKey, new String[]{"status", "gmtModified"});
            String previousStatus = (String)statusAndGmtModified.get(0);
            if (StringUtils.isEmpty((CharSequence)previousStatus)) {
                jedis.unwatch();
                throw new StoreException("Global transaction is not exist, update global transaction failed.");
            }
            if (previousStatus.equals(String.valueOf(globalTransactionDO.getStatus()))) {
                jedis.unwatch();
                boolean bl = true;
                return bl;
            }
            String previousGmtModified = (String)statusAndGmtModified.get(1);
            Transaction multi = jedis.multi();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("status", String.valueOf(globalTransactionDO.getStatus()));
            map.put("gmtModified", String.valueOf(new Date().getTime()));
            multi.hmset(globalKey, map);
            multi.lrem(this.buildGlobalStatus(Integer.valueOf(previousStatus)), 0L, xid);
            multi.rpush(this.buildGlobalStatus(globalTransactionDO.getStatus()), new String[]{xid});
            List exec = multi.exec();
            if (CollectionUtils.isEmpty((Collection)exec)) {
                LOGGER.warn("The global transaction xid = {}, maybe changed by another TC. It does not affect the results", (Object)globalTransactionDO.getXid());
                boolean bl = true;
                return bl;
            }
            String hmset = exec.get(0).toString();
            long lrem = (Long)exec.get(1);
            long rpush = (Long)exec.get(2);
            if (OK.equalsIgnoreCase(hmset) && lrem > 0L && rpush > 0L) {
                boolean bl = true;
                return bl;
            }
            if (OK.equalsIgnoreCase(hmset)) {
                jedis.watch(new String[]{globalKey});
                String xid2 = jedis.hget(globalKey, "xid");
                if (StringUtils.isNotEmpty((CharSequence)xid2)) {
                    HashMap<String, String> mapPrevious = new HashMap<String, String>(2, 1.0f);
                    mapPrevious.put("status", previousStatus);
                    mapPrevious.put("gmtModified", previousGmtModified);
                    Transaction multi2 = jedis.multi();
                    multi2.hmset(globalKey, mapPrevious);
                    multi2.exec();
                }
            }
            if (lrem > 0L) {
                jedis.rpush(this.buildGlobalStatus(Integer.valueOf(previousStatus)), new String[]{xid});
            }
            if (rpush > 0L) {
                jedis.lrem(this.buildGlobalStatus(globalTransactionDO.getStatus()), 0L, xid);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    @Override
    public GlobalSession readSession(String xid, boolean withBranchSessions) {
        String transactionId = String.valueOf(XID.getTransactionId((String)xid));
        String globalKey = this.buildGlobalKeyByTransactionId(transactionId);
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            GlobalSession session;
            Map map = jedis.hgetAll(globalKey);
            if (CollectionUtils.isEmpty((Map)map)) {
                GlobalSession globalSession = null;
                return globalSession;
            }
            GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
            List<BranchTransactionDO> branchTransactionDOs = null;
            if (withBranchSessions) {
                branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
            }
            GlobalSession globalSession = session = this.getGlobalSession(globalTransactionDO, branchTransactionDOs, withBranchSessions);
            return globalSession;
        }
    }

    @Override
    public GlobalSession readSession(String xid) {
        return this.readSession(xid, true);
    }

    @Override
    public List<GlobalSession> readSession(GlobalStatus[] statuses, boolean withBranchSessions) {
        List<GlobalSession> globalSessions = Collections.synchronizedList(new ArrayList());
        List<String> statusKeys = this.convertStatusKeys(statuses);
        Map<String, Integer> targetMap = this.calculateStatuskeysHasData(statusKeys);
        if (targetMap.size() == 0 || this.logQueryLimit <= 0) {
            return globalSessions;
        }
        int perStatusLimit = this.resetLogQueryLimit(targetMap);
        long countGlobalSessions = targetMap.values().stream().collect(Collectors.summarizingInt(Integer::intValue)).getSum();
        long queryCount = Math.min((long)this.logQueryLimit, countGlobalSessions);
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        this.dogetXidsForTargetMapRecursive(targetMap, 0L, perStatusLimit - 1, queryCount, list);
        if (CollectionUtils.isNotEmpty(list)) {
            List xids = list.stream().flatMap(Collection::stream).collect(Collectors.toList());
            xids.parallelStream().forEach(xid -> {
                GlobalSession globalSession = this.readSession((String)xid, withBranchSessions);
                if (globalSession != null) {
                    globalSessions.add(globalSession);
                }
            });
        }
        return globalSessions;
    }

    private int resetLogQueryLimit(Map<String, Integer> targetMap) {
        int resetLimitQuery = this.logQueryLimit;
        if (targetMap.size() > 1) {
            int size = targetMap.size();
            resetLimitQuery = this.logQueryLimit / size == 0 ? 1 : this.logQueryLimit / size;
        }
        return resetLimitQuery;
    }

    @Override
    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        if (StringUtils.isNotEmpty((CharSequence)sessionCondition.getXid())) {
            GlobalSession globalSession = this.readSession(sessionCondition.getXid(), !sessionCondition.isLazyLoadBranch());
            if (globalSession != null) {
                globalSessions.add(globalSession);
            }
            return globalSessions;
        }
        if (sessionCondition.getTransactionId() != null) {
            GlobalSession globalSession = this.readSessionByTransactionId(sessionCondition.getTransactionId().toString(), !sessionCondition.isLazyLoadBranch());
            if (globalSession != null) {
                globalSessions.add(globalSession);
            }
            return globalSessions;
        }
        if (CollectionUtils.isNotEmpty((Object[])sessionCondition.getStatuses())) {
            return this.readSession(sessionCondition.getStatuses(), !sessionCondition.isLazyLoadBranch());
        }
        if (sessionCondition.getStatus() != null) {
            return this.readSession(new GlobalStatus[]{sessionCondition.getStatus()}, !sessionCondition.isLazyLoadBranch());
        }
        return null;
    }

    public List<GlobalSession> readSessionStatusByPage(GlobalSessionParam param) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        int pageNum = param.getPageNum();
        int pageSize = param.getPageSize();
        int start = Math.max((pageNum - 1) * pageSize, 0);
        int end = pageNum * pageSize - 1;
        if (param.getStatus() != null) {
            String statusKey = this.buildGlobalStatus(GlobalStatus.get((int)param.getStatus()).getCode());
            try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
                List xids = jedis.lrange(statusKey, (long)start, (long)end);
                xids.forEach(xid -> {
                    GlobalSession globalSession = this.readSession((String)xid, param.isWithBranch());
                    if (globalSession != null) {
                        globalSessions.add(globalSession);
                    }
                });
            }
        }
        return globalSessions;
    }

    private GlobalSession getGlobalSession(GlobalTransactionDO globalTransactionDO, List<BranchTransactionDO> branchTransactionDOs, boolean withBranchSessions) {
        GlobalSession globalSession = SessionConverter.convertGlobalSession(globalTransactionDO, !withBranchSessions);
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            for (BranchTransactionDO branchTransactionDO : branchTransactionDOs) {
                globalSession.add(SessionConverter.convertBranchSession(branchTransactionDO));
            }
        }
        return globalSession;
    }

    private GlobalSession readSessionByTransactionId(String transactionId, boolean withBranchSessions) {
        String globalKey = this.buildGlobalKeyByTransactionId(transactionId);
        String xid = null;
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map map = jedis.hgetAll(globalKey);
            if (CollectionUtils.isEmpty((Map)map)) {
                GlobalSession globalSession = null;
                return globalSession;
            }
            GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
            if (globalTransactionDO != null) {
                xid = globalTransactionDO.getXid();
            }
            List<BranchTransactionDO> branchTransactionDOs = new ArrayList<BranchTransactionDO>();
            if (withBranchSessions) {
                branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
            }
            GlobalSession globalSession = this.getGlobalSession(globalTransactionDO, branchTransactionDOs, withBranchSessions);
            return globalSession;
        }
    }

    private List<BranchTransactionDO> readBranchSessionByXid(Jedis jedis, String xid) {
        ArrayList<BranchTransactionDO> branchTransactionDOs = new ArrayList<BranchTransactionDO>();
        String branchListKey = this.buildBranchListKeyByXid(xid);
        List<String> branchKeys = this.lRange(jedis, branchListKey);
        if (CollectionUtils.isNotEmpty(branchKeys)) {
            try (Pipeline pipeline = jedis.pipelined();){
                branchKeys.stream().forEach(branchKey -> pipeline.hgetAll(branchKey));
                List branchInfos = pipeline.syncAndReturnAll();
                for (Object branchInfo : branchInfos) {
                    if (branchInfo == null) continue;
                    Map branchInfoMap = (Map)branchInfo;
                    Optional<BranchTransactionDO> branchTransactionDO = Optional.ofNullable((BranchTransactionDO)BeanUtils.mapToObject((Map)branchInfoMap, BranchTransactionDO.class));
                    branchTransactionDO.ifPresent(branchTransactionDOs::add);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            Collections.sort(branchTransactionDOs);
        }
        return branchTransactionDOs;
    }

    private List<String> lRange(Jedis jedis, String key) {
        ArrayList<String> keys = new ArrayList<String>();
        int limit = 20;
        int start = 0;
        int stop = limit;
        while (true) {
            List values = jedis.lrange(key, (long)start, (long)stop);
            keys.addAll(values);
            if (CollectionUtils.isEmpty((Collection)values) || values.size() < limit) break;
            start = keys.size();
            stop = start + limit;
        }
        return keys;
    }

    public List<BranchTransactionDO> findBranchSessionByXid(String xid) {
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            List<BranchTransactionDO> list = this.readBranchSessionByXid(jedis, xid);
            return list;
        }
    }

    public List<GlobalSession> findGlobalSessionByPage(int pageNum, int pageSize, boolean withBranchSessions) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        int start = Math.max((pageNum - 1) * pageSize, 0);
        int end = pageNum * pageSize - 1;
        List<String> statusKeys = this.convertStatusKeys(GlobalStatus.values());
        Map<String, Integer> stringLongMap = this.calculateStatuskeysHasData(statusKeys);
        List<List<String>> list = this.dogetXidsForTargetMap(stringLongMap, start, end, pageSize);
        if (CollectionUtils.isNotEmpty(list)) {
            List<String> xids = list.stream().flatMap(Collection::stream).collect(Collectors.toList());
            xids.forEach(xid -> {
                GlobalSession globalSession;
                if (globalSessions.size() < pageSize && (globalSession = this.readSession((String)xid, withBranchSessions)) != null) {
                    globalSessions.add(globalSession);
                }
            });
        }
        return globalSessions;
    }

    private Map<String, Integer> calculateStatuskeysHasData(List<String> statusKeys) {
        Map<String, Integer> resultMap = Collections.synchronizedMap(new LinkedHashMap());
        HashMap<String, Integer> keysMap = new HashMap<String, Integer>(statusKeys.size());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();
             Pipeline pipelined = jedis.pipelined();){
            statusKeys.forEach(key -> pipelined.llen(key));
            List counts = pipelined.syncAndReturnAll();
            for (int i = 0; i < counts.size(); ++i) {
                if ((Long)counts.get(i) <= 0L) continue;
                keysMap.put(statusKeys.get(i), ((Long)counts.get(i)).intValue());
            }
        }
        ArrayList list = new ArrayList(keysMap.entrySet());
        list.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        list.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)resultMap.put((String)e.getKey(), (Integer)e.getValue());
        });
        return resultMap;
    }

    /*
     * Exception decompiling
     */
    public Long countByGlobalSessions(GlobalStatus[] values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> convertStatusKeys(GlobalStatus[] statuses) {
        ArrayList<String> statusKeys = new ArrayList<String>();
        for (int i = 0; i < statuses.length; ++i) {
            statusKeys.add(this.buildGlobalStatus(statuses[i].getCode()));
        }
        return statusKeys;
    }

    private void dogetXidsForTargetMapRecursive(Map<String, Integer> targetMap, long start, long end, long queryCount, List<List<String>> listList) {
        long total = listList.stream().mapToLong(List::size).sum();
        if (total >= queryCount) {
            return;
        }
        if (start >= queryCount) {
            return;
        }
        if (targetMap.size() == 0) {
            return;
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            for (String key : targetMap.keySet()) {
                List list;
                long sum = listList.stream().mapToLong(List::size).sum();
                long diffCount = queryCount - sum;
                if (diffCount <= 0L) {
                    return;
                }
                if (end - start >= diffCount) {
                    long endNew = start + diffCount - 1L;
                    list = jedis.lrange(key, start, endNew);
                } else {
                    list = jedis.lrange(key, start, end);
                }
                if (list.size() > 0 && sum < queryCount) {
                    listList.add(list);
                    continue;
                }
                if (list.size() != 0) continue;
                targetMap.remove(key);
            }
        }
        long startNew = end + 1L;
        long endNew = startNew + end - start;
        this.dogetXidsForTargetMapRecursive(targetMap, startNew, endNew, queryCount, listList);
    }

    private List<List<String>> dogetXidsForTargetMap(Map<String, Integer> targetMap, int start, int end, int totalCount) {
        ArrayList<List<String>> listList = new ArrayList<List<String>>();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            for (String key : targetMap.keySet()) {
                List list = jedis.lrange(key, (long)start, (long)end);
                long sum = listList.stream().mapToLong(List::size).sum();
                if (list.size() > 0 && sum < (long)totalCount) {
                    listList.add(list);
                    continue;
                }
                start = 0;
                end = totalCount - 1;
            }
        }
        return listList;
    }

    private String buildBranchListKeyByXid(String xid) {
        return REDIS_SEATA_BRANCHES_PREFIX + xid;
    }

    private String buildGlobalKeyByTransactionId(Object transactionId) {
        return REDIS_SEATA_GLOBAL_PREFIX + transactionId;
    }

    private String buildBranchKey(Long branchId) {
        return REDIS_SEATA_BRANCH_PREFIX + branchId;
    }

    private String buildGlobalStatus(Integer status) {
        return REDIS_SEATA_STATUS_PREFIX + status;
    }

    public void setLogQueryLimit(int logQueryLimit) {
        this.logQueryLimit = logQueryLimit;
    }

    private static /* synthetic */ long lambda$countByGlobalSessions$8(Long value) {
        return value;
    }

    private static /* synthetic */ void lambda$countByGlobalSessions$7(Pipeline pipelined, String statusKey) {
        pipelined.llen(statusKey);
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
    }
}

