/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.transaction.at;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.common.exception.StoreException;
import io.seata.common.util.StringUtils;
import io.seata.core.exception.BranchTransactionException;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.BranchType;
import io.seata.core.rpc.RemotingServer;
import io.seata.server.coordinator.AbstractCore;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ATCore
extends AbstractCore {
    private ObjectMapper objectMapper;

    public ATCore(RemotingServer remotingServer) {
        super(remotingServer);
    }

    @Override
    public BranchType getHandleBranchType() {
        return BranchType.AT;
    }

    @Override
    protected void branchSessionLock(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        String applicationData = branchSession.getApplicationData();
        boolean autoCommit = true;
        boolean skipCheckLock = false;
        if (StringUtils.isNotBlank((String)applicationData)) {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper();
            }
            try {
                Object clientSkipCheckLock;
                Map data = (Map)this.objectMapper.readValue(applicationData, HashMap.class);
                Object clientAutoCommit = data.get("autoCommit");
                if (clientAutoCommit != null && !((Boolean)clientAutoCommit).booleanValue()) {
                    autoCommit = (Boolean)clientAutoCommit;
                }
                if ((clientSkipCheckLock = data.get("skipCheckLock")) instanceof Boolean) {
                    skipCheckLock = (Boolean)clientSkipCheckLock;
                }
            }
            catch (IOException e) {
                LOGGER.error("failed to get application data: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        try {
            if (!branchSession.lock(autoCommit, skipCheckLock)) {
                throw new BranchTransactionException(TransactionExceptionCode.LockKeyConflict, String.format("Global lock acquire failed xid = %s branchId = %s", globalSession.getXid(), branchSession.getBranchId()));
            }
        }
        catch (StoreException e) {
            if (e.getCause() instanceof BranchTransactionException) {
                throw new BranchTransactionException(((BranchTransactionException)e.getCause()).getCode(), String.format("Global lock acquire failed xid = %s branchId = %s", globalSession.getXid(), branchSession.getBranchId()));
            }
            throw e;
        }
    }

    @Override
    protected void branchSessionUnlock(BranchSession branchSession) throws TransactionException {
        branchSession.unlock();
    }

    @Override
    public boolean lockQuery(BranchType branchType, String resourceId, String xid, String lockKeys) throws TransactionException {
        return this.lockManager.isLockable(xid, resourceId, lockKeys);
    }
}

