/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.ReflectionUtil;
import io.seata.rm.tcc.remoting.Protocols;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.AbstractedRemotingParser;

public class DubboRemotingParser
extends AbstractedRemotingParser {
    @Override
    public boolean isReference(Object bean, String beanName) throws FrameworkException {
        Class<?> c = bean.getClass();
        return "com.alibaba.dubbo.config.spring.ReferenceBean".equals(c.getName()) || "org.apache.dubbo.config.spring.ReferenceBean".equals(c.getName());
    }

    @Override
    public boolean isService(Object bean, String beanName) throws FrameworkException {
        Class<?> c = bean.getClass();
        return "com.alibaba.dubbo.config.spring.ServiceBean".equals(c.getName()) || "org.apache.dubbo.config.spring.ServiceBean".equals(c.getName());
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        if (!this.isRemoting(bean, beanName)) {
            return null;
        }
        try {
            RemotingDesc serviceBeanDesc = new RemotingDesc();
            Class interfaceClass = (Class)ReflectionUtil.invokeMethod((Object)bean, (String)"getInterfaceClass");
            String interfaceClassName = (String)ReflectionUtil.getFieldValue((Object)bean, (String)"interfaceName");
            String version = (String)ReflectionUtil.invokeMethod((Object)bean, (String)"getVersion");
            String group = (String)ReflectionUtil.invokeMethod((Object)bean, (String)"getGroup");
            serviceBeanDesc.setInterfaceClass(interfaceClass);
            serviceBeanDesc.setInterfaceClassName(interfaceClassName);
            serviceBeanDesc.setUniqueId(version);
            serviceBeanDesc.setGroup(group);
            serviceBeanDesc.setProtocol(Protocols.DUBBO);
            if (this.isService(bean, beanName)) {
                Object targetBean = ReflectionUtil.getFieldValue((Object)bean, (String)"ref");
                serviceBeanDesc.setTargetBean(targetBean);
            }
            return serviceBeanDesc;
        }
        catch (Throwable t) {
            throw new FrameworkException(t);
        }
    }

    @Override
    public short getProtocol() {
        return Protocols.DUBBO;
    }
}

