/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.TransactionManager;
import io.seata.tm.DefaultTransactionManager;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalTransaction
implements GlobalTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGlobalTransaction.class);
    private static final int DEFAULT_GLOBAL_TX_TIMEOUT = 60000;
    private static final String DEFAULT_GLOBAL_TX_NAME = "default";
    private TransactionManager transactionManager = DefaultTransactionManager.get();
    private String xid;
    private GlobalStatus status;
    private GlobalTransactionRole role;

    DefaultGlobalTransaction() {
        this(null, GlobalStatus.UnKnown, GlobalTransactionRole.Launcher);
    }

    DefaultGlobalTransaction(String xid, GlobalStatus status, GlobalTransactionRole role) {
        this.xid = xid;
        this.status = status;
        this.role = role;
    }

    @Override
    public void begin() throws TransactionException {
        this.begin(60000);
    }

    @Override
    public void begin(int timeout) throws TransactionException {
        this.begin(timeout, DEFAULT_GLOBAL_TX_NAME);
    }

    @Override
    public void begin(int timeout, String name) throws TransactionException {
        if (this.role != GlobalTransactionRole.Launcher) {
            this.check();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Begin(): just involved in global transaction [" + this.xid + "]");
            }
            return;
        }
        if (this.xid != null) {
            throw new IllegalStateException();
        }
        if (RootContext.getXID() != null) {
            throw new IllegalStateException();
        }
        this.xid = this.transactionManager.begin(null, null, name, timeout);
        this.status = GlobalStatus.Begin;
        RootContext.bind((String)this.xid);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Begin a NEW global transaction [" + this.xid + "]");
        }
    }

    @Override
    public void commit() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Commit(): just involved in global transaction [" + this.xid + "]");
            }
            return;
        }
        if (this.xid == null) {
            throw new IllegalStateException();
        }
        this.status = this.transactionManager.commit(this.xid);
        if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
            RootContext.unbind();
        }
    }

    @Override
    public void rollback() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Rollback(): just involved in global transaction [" + this.xid + "]");
            }
            return;
        }
        if (this.xid == null) {
            throw new IllegalStateException();
        }
        this.status = this.transactionManager.rollback(this.xid);
        if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
            RootContext.unbind();
        }
    }

    @Override
    public GlobalStatus getStatus() throws TransactionException {
        if (this.xid == null) {
            return GlobalStatus.UnKnown;
        }
        this.status = this.transactionManager.getStatus(this.xid);
        return this.status;
    }

    @Override
    public String getXid() {
        return this.xid;
    }

    private void check() {
        if (this.xid == null) {
            throw new ShouldNeverHappenException();
        }
    }
}

