/*
 * Decompiled with CFR 0.152.
 */
package seatsio;

import seatsio.Region;
import seatsio.charts.Charts;
import seatsio.eventLog.EventLog;
import seatsio.events.Events;
import seatsio.holdTokens.HoldTokens;
import seatsio.reports.charts.ChartReports;
import seatsio.reports.events.EventReports;
import seatsio.reports.usage.UsageReports;
import seatsio.seasons.Seasons;
import seatsio.util.UnirestWrapper;
import seatsio.workspaces.Workspaces;

public class SeatsioClient {
    private final String baseUrl;
    private final UnirestWrapper unirest;
    public final Workspaces workspaces;
    public final HoldTokens holdTokens;
    public final Charts charts;
    public final Events events;
    public final Seasons seasons;
    public final EventReports eventReports;
    public final ChartReports chartReports;
    public final UsageReports usageReports;
    public final EventLog eventLog;

    public SeatsioClient(String secretKey, String workspaceKey, String baseUrl) {
        this.baseUrl = baseUrl;
        this.unirest = new UnirestWrapper(secretKey, workspaceKey);
        this.workspaces = new Workspaces(baseUrl, this.unirest);
        this.holdTokens = new HoldTokens(baseUrl, this.unirest);
        this.charts = new Charts(baseUrl, this.unirest);
        this.events = new Events(baseUrl, this.unirest);
        this.seasons = new Seasons(baseUrl, this.unirest, this);
        this.eventReports = new EventReports(baseUrl, this.unirest);
        this.chartReports = new ChartReports(baseUrl, this.unirest);
        this.usageReports = new UsageReports(baseUrl, this.unirest);
        this.eventLog = new EventLog(baseUrl, this.unirest);
    }

    public SeatsioClient(Region region, String secretKey, String workspaceKey) {
        this(secretKey, workspaceKey, region.getUrl());
    }

    public SeatsioClient(Region region, String secretKey) {
        this(region, secretKey, null);
    }

    public SeatsioClient maxRetries(int maxRetries) {
        this.unirest.maxRetries(maxRetries);
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void reinitializeHttpConnectionPool() {
        SeatsioClient seatsioClient = this;
        seatsioClient.unirest.reinitializeHttpConnectionPool();
    }
}

