/*
 * Decompiled with CFR 0.152.
 */
package seatsio.charts;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import seatsio.charts.LongCategoryKey;
import seatsio.charts.StringCategoryKey;
import seatsio.util.ValueObject;

public abstract class CategoryKey
extends ValueObject {
    public static CategoryKey of(Long categoryKey) {
        if (categoryKey == null) {
            return null;
        }
        return new LongCategoryKey(categoryKey);
    }

    public static CategoryKey of(String categoryKey) {
        if (categoryKey == null) {
            return null;
        }
        return new StringCategoryKey(categoryKey);
    }

    public abstract boolean isLong();

    public abstract long toLong();

    @Override
    public abstract String toString();

    public abstract JsonElement toJson();

    public static class CategoryKeyJsonDeserializer
    implements JsonDeserializer<CategoryKey> {
        public CategoryKey deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement == null) {
                return null;
            }
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return CategoryKey.of(primitive.getAsLong());
            }
            return CategoryKey.of(primitive.getAsString());
        }
    }

    public static class CategoryKeyJsonSerializer
    implements JsonSerializer<CategoryKey> {
        public JsonElement serialize(CategoryKey categoryKey, Type type, JsonSerializationContext jsonSerializationContext) {
            if (categoryKey == null) {
                return null;
            }
            return categoryKey.toJson();
        }
    }
}

