/*
 * Decompiled with CFR 0.152.
 */
package seatsio.charts;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import seatsio.charts.Category;
import seatsio.charts.CategoryKey;
import seatsio.charts.Chart;
import seatsio.charts.ChartListParams;
import seatsio.charts.ChartValidationResult;
import seatsio.json.JsonObjectBuilder;
import seatsio.json.SeatsioGson;
import seatsio.util.Lister;
import seatsio.util.Page;
import seatsio.util.PageFetcher;
import seatsio.util.ParameterizedLister;
import seatsio.util.UnirestWrapper;

public class Charts {
    private final String baseUrl;
    private final UnirestWrapper unirest;
    public final Lister<Chart> archive;

    public Charts(String baseUrl, UnirestWrapper unirest) {
        this.baseUrl = baseUrl;
        this.archive = new Lister<Chart>(new PageFetcher<Chart>(baseUrl, "/charts/archive", unirest, Chart.class));
        this.unirest = unirest;
    }

    public Chart retrieve(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}").routeParam("key", key));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public Chart retrieveWithEvents(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}?expand=events").routeParam("key", key));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public Chart create() {
        return this.create(null);
    }

    public Chart create(String name) {
        return this.create(name, null);
    }

    public Chart create(String name, String venueType) {
        return this.create(name, venueType, null);
    }

    public Chart create(String name, String venueType, List<Category> categories) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("name", name).withPropertyIfNotNull("venueType", venueType).withPropertyIfNotNull("categories", categories, category -> SeatsioGson.gson().toJsonTree(category));
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.post(this.baseUrl + "/charts").body(request.build().toString()));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public Map<?, ?> retrievePublishedVersion(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}/version/published").routeParam("key", key));
        return (Map)SeatsioGson.gson().fromJson(response, Map.class);
    }

    public byte[] retrievePublishedVersionThumbnail(String key) {
        return this.unirest.binaryResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}/version/published/thumbnail").routeParam("key", key));
    }

    public Map<?, ?> retrieveDraftVersion(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}/version/draft").routeParam("key", key));
        return (Map)SeatsioGson.gson().fromJson(response, Map.class);
    }

    public byte[] retrieveDraftVersionThumbnail(String key) {
        return this.unirest.binaryResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}/version/draft/thumbnail").routeParam("key", key));
    }

    public void update(String key, String name) {
        this.update(key, name, null);
    }

    public void update(String key, String name, List<Category> categories) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/charts/{key}").routeParam("key", key)).body(JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("name", name).withPropertyIfNotNull("categories", categories, category -> SeatsioGson.gson().toJsonTree(category)).buildAsString()));
    }

    public void addCategory(String chartKey, Category category) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/charts/{key}/categories").routeParam("key", chartKey)).body(SeatsioGson.gson().toJsonTree((Object)category).toString()));
    }

    public void removeCategory(String chartKey, CategoryKey categoryKey) {
        this.unirest.stringResponse(((HttpRequestWithBody)UnirestWrapper.delete(this.baseUrl + "/charts/{chartKey}/categories/{categoryKey}").routeParam("chartKey", chartKey)).routeParam("categoryKey", categoryKey.toString()));
    }

    public List<Category> listCategories(String chartKey) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/charts/{key}/categories").routeParam("key", chartKey));
        Gson gson = SeatsioGson.gson();
        return ((ListCategoriesResponse)gson.fromJson((String)response, ListCategoriesResponse.class)).categories;
    }

    public Chart copy(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/version/published/actions/copy").routeParam("key", key));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public void moveToArchive(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/actions/move-to-archive").routeParam("key", key));
    }

    public void moveOutOfArchive(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/actions/move-out-of-archive").routeParam("key", key));
    }

    public void publishDraftVersion(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/version/draft/actions/publish").routeParam("key", key));
    }

    public void discardDraftVersion(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/version/draft/actions/discard").routeParam("key", key));
    }

    public Chart copyDraftVersion(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/version/draft/actions/copy").routeParam("key", key));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public Chart copyToWorkspace(String chartKey, String toWorkspaceKey) {
        String response = this.unirest.stringResponse(((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/charts/{chartKey}/version/published/actions/copy-to-workspace/{workspaceKey}").routeParam("chartKey", chartKey)).routeParam("workspaceKey", toWorkspaceKey));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public Chart copyToWorkspace(String chartKey, String fromWorkspaceKey, String toWorkspaceKey) {
        String response = this.unirest.stringResponse(((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/charts/{chartKey}/version/published/actions/copy/from/{fromWorkspaceKey}/to/{toWorkspaceKey}").routeParam("chartKey", chartKey)).routeParam("fromWorkspaceKey", fromWorkspaceKey)).routeParam("toWorkspaceKey", toWorkspaceKey));
        return (Chart)SeatsioGson.gson().fromJson(response, Chart.class);
    }

    public void addTag(String key, String tag) {
        this.unirest.stringResponse(((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/charts/{key}/tags/{tag}").routeParam("key", key)).routeParam("tag", tag));
    }

    public void removeTag(String key, String tag) {
        this.unirest.stringResponse(((HttpRequestWithBody)UnirestWrapper.delete(this.baseUrl + "/charts/{key}/tags/{tag}").routeParam("key", key)).routeParam("tag", tag));
    }

    public ChartValidationResult validatePublishedVersion(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/version/published/actions/validate").routeParam("key", key));
        return (ChartValidationResult)SeatsioGson.gson().fromJson(response, ChartValidationResult.class);
    }

    public ChartValidationResult validateDraftVersion(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/charts/{key}/version/draft/actions/validate").routeParam("key", key));
        return (ChartValidationResult)SeatsioGson.gson().fromJson(response, ChartValidationResult.class);
    }

    public List<String> listAllTags() {
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.get(this.baseUrl + "/charts/tags"));
        JsonElement tags = JsonParser.parseString((String)response).getAsJsonObject().get("tags");
        return (List)SeatsioGson.gson().fromJson(tags, List.class);
    }

    public Stream<Chart> listAll() {
        return this.listAll(new ChartListParams());
    }

    public Stream<Chart> listAll(ChartListParams chartListParams) {
        return this.list().all(chartListParams.asMap());
    }

    public Page<Chart> listFirstPage() {
        return this.listFirstPage(new ChartListParams(), null);
    }

    public Page<Chart> listFirstPage(ChartListParams chartListParams, Integer pageSize) {
        return this.list().firstPage(this.toMap(chartListParams), pageSize);
    }

    public Page<Chart> listPageAfter(long id) {
        return this.listPageAfter(id, new ChartListParams(), null);
    }

    public Page<Chart> listPageAfter(long id, ChartListParams chartListParams, Integer pageSize) {
        return this.list().pageAfter(id, this.toMap(chartListParams), pageSize);
    }

    public Page<Chart> listPageBefore(long id) {
        return this.listPageBefore(id, new ChartListParams(), null);
    }

    public Page<Chart> listPageBefore(long id, ChartListParams chartListParams, Integer pageSize) {
        return this.list().pageBefore(id, this.toMap(chartListParams), pageSize);
    }

    private ParameterizedLister<Chart> list() {
        return new ParameterizedLister<Chart>(new PageFetcher<Chart>(this.baseUrl, "/charts", this.unirest, Chart.class));
    }

    private Map<String, Object> toMap(ChartListParams chartListParams) {
        if (chartListParams == null) {
            return new HashMap<String, Object>();
        }
        return chartListParams.asMap();
    }

    private static final class ListCategoriesResponse {
        public List<Category> categories;

        private ListCategoriesResponse() {
        }
    }
}

