/*
 * Decompiled with CFR 0.152.
 */
package seatsio.events;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import seatsio.charts.Category;
import seatsio.charts.CategoryKey;
import seatsio.events.Channel;
import seatsio.events.ForSaleConfig;
import seatsio.events.TableBookingConfig;
import seatsio.json.SeatsioGson;
import seatsio.seasons.Season;
import seatsio.util.ValueObject;

public class Event
extends ValueObject {
    public long id;
    public String key;
    public String chartKey;
    public String name;
    public LocalDate date;
    public ForSaleConfig forSaleConfig;
    public Boolean supportsBestAvailable;
    public Instant createdOn;
    public Instant updatedOn;
    public TableBookingConfig tableBookingConfig;
    public List<Channel> channels;
    public String topLevelSeasonKey;
    public boolean isTopLevelSeason;
    public boolean isPartialSeason;
    public boolean isEventInSeason;
    public Map<String, CategoryKey> objectCategories;
    public List<Category> categories;
    public boolean isInThePast;
    public List<String> partialSeasonKeysForEvent;

    public boolean isSeason() {
        return false;
    }

    public static class EventJsonDeserializer
    implements JsonDeserializer<Event> {
        public Event deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject event = jsonElement.getAsJsonObject();
            if (event.getAsJsonPrimitive("isSeason").getAsBoolean()) {
                return (Event)SeatsioGson.gsonBuilder().create().fromJson((JsonElement)event, Season.class);
            }
            return (Event)SeatsioGson.gsonBuilder().create().fromJson((JsonElement)event, Event.class);
        }
    }
}

