/*
 * Decompiled with CFR 0.152.
 */
package seatsio.events;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import seatsio.SortDirection;
import seatsio.charts.Category;
import seatsio.charts.CategoryKey;
import seatsio.events.BestAvailable;
import seatsio.events.BestAvailableResult;
import seatsio.events.ChangeObjectStatusResult;
import seatsio.events.Channels;
import seatsio.events.CreateEventParams;
import seatsio.events.Event;
import seatsio.events.EventCreationResult;
import seatsio.events.EventObjectInfo;
import seatsio.events.ObjectProperties;
import seatsio.events.StatusChange;
import seatsio.events.StatusChangeRequest;
import seatsio.events.UpdateEventParams;
import seatsio.json.JsonArrayBuilder;
import seatsio.json.JsonObjectBuilder;
import seatsio.json.SeatsioGson;
import seatsio.util.Lister;
import seatsio.util.Page;
import seatsio.util.PageFetcher;
import seatsio.util.UnirestWrapper;
import seatsio.util.ValueObject;

public class Events {
    private final String baseUrl;
    private final UnirestWrapper unirest;
    public final Channels channels;

    public Events(String baseUrl, UnirestWrapper unirest) {
        this.baseUrl = baseUrl;
        this.unirest = unirest;
        this.channels = new Channels(baseUrl, unirest);
    }

    public Event create(String chartKey) {
        return this.create(chartKey, new CreateEventParams());
    }

    public Event create(String chartKey, CreateEventParams params) {
        String request = JsonObjectBuilder.aJsonObject().withProperty("chartKey", chartKey).withPropertyIfNotNull("eventKey", params.eventKey).withPropertyIfNotNull("name", params.name).withPropertyIfNotNull("date", params.date == null ? null : SeatsioGson.gson().toJsonTree((Object)params.date)).withPropertyIfNotNull("tableBookingConfig", params.tableBookingConfig).withPropertyIfNotNull("objectCategories", params.objectCategories, CategoryKey::toJson).withPropertyIfNotNull("categories", params.getCategoriesAsJson()).withPropertyIfNotNull("channels", params.getChannelsAsJson()).withPropertyIfNotNull("forSaleConfig", params.getForSaleConfigAsJson()).buildAsString();
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.post(this.baseUrl + "/events").body(request));
        return (Event)SeatsioGson.gson().fromJson(response, Event.class);
    }

    public List<Event> create(String chartKey, Collection<CreateEventParams> params) {
        JsonArray events = new JsonArray();
        new ArrayList<CreateEventParams>(params).forEach(p -> events.add((JsonElement)JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("eventKey", p.eventKey).withPropertyIfNotNull("name", p.name).withPropertyIfNotNull("date", p.date == null ? null : SeatsioGson.gson().toJsonTree((Object)p.date)).withPropertyIfNotNull("tableBookingConfig", p.tableBookingConfig).withPropertyIfNotNull("objectCategories", p.objectCategories, CategoryKey::toJson).withPropertyIfNotNull("categories", p.getCategoriesAsJson()).withPropertyIfNotNull("channels", p.getChannelsAsJson()).withPropertyIfNotNull("forSaleConfig", p.getForSaleConfigAsJson()).build()));
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withProperty("chartKey", chartKey).withProperty("events", (JsonElement)events);
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.post(this.baseUrl + "/events/actions/create-multiple").body(request.build().toString()));
        return ((EventCreationResult)SeatsioGson.gson().fromJson((String)response, EventCreationResult.class)).events;
    }

    public void removeObjectCategories(String eventKey) {
        this.update(eventKey, (UpdateEventParams)new UpdateEventParams().withObjectCategories(Maps.newHashMap()));
    }

    public void removeCategories(String eventKey) {
        this.update(eventKey, (UpdateEventParams)new UpdateEventParams().withCategories(new ArrayList<Category>()));
    }

    public void update(String key, UpdateEventParams params) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("chartKey", params.chartKey).withPropertyIfNotNull("eventKey", params.eventKey).withPropertyIfNotNull("name", params.name).withPropertyIfNotNull("date", params.date == null ? null : SeatsioGson.gson().toJsonTree((Object)params.date)).withPropertyIfNotNull("tableBookingConfig", params.tableBookingConfig).withPropertyIfNotNull("objectCategories", params.objectCategories, CategoryKey::toJson).withPropertyIfNotNull("categories", this.categoriesAsJson(params.categories)).withPropertyIfNotNull("isInThePast", params.isInThePast);
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}").routeParam("key", key)).body(request.build().toString()));
    }

    private List<JsonObject> categoriesAsJson(List<Category> categories) {
        if (categories == null) {
            return null;
        }
        return categories.stream().map(Category::toJson).collect(Collectors.toList());
    }

    public void delete(String key) {
        this.unirest.stringResponse(UnirestWrapper.delete(this.baseUrl + "/events/{key}").routeParam("key", key));
    }

    public Event retrieve(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/events/{key}").routeParam("key", key));
        return (Event)SeatsioGson.gson().fromJson(response, Event.class);
    }

    public void markAsForSale(String key, List<String> objects, Map<String, Integer> areaPlaces, List<String> categories) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/actions/mark-as-for-sale").routeParam("key", key)).body(this.forSaleRequest(objects, areaPlaces, categories).toString()));
    }

    public void markAsNotForSale(String key, List<String> objects, Map<String, Integer> areaPlaces, List<String> categories) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/actions/mark-as-not-for-sale").routeParam("key", key)).body(this.forSaleRequest(objects, areaPlaces, categories).toString()));
    }

    private JsonObject forSaleRequest(List<String> objects, Map<String, Integer> areaPlaces, List<String> categories) {
        return JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("objects", objects).withPropertyIfNotNull("areaPlaces", areaPlaces).withPropertyIfNotNull("categories", categories).build();
    }

    public void markEverythingAsForSale(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/events/{key}/actions/mark-everything-as-for-sale").routeParam("key", key));
    }

    public Stream<Event> listAll() {
        return this.list().all();
    }

    public Page<Event> listFirstPage() {
        return this.listFirstPage(null);
    }

    public Page<Event> listFirstPage(Integer pageSize) {
        return this.list().firstPage(pageSize);
    }

    public Page<Event> listPageAfter(long id) {
        return this.listPageAfter(id, null);
    }

    public Page<Event> listPageAfter(long id, Integer pageSize) {
        return this.list().pageAfter(id, pageSize);
    }

    public Page<Event> listPageBefore(long id) {
        return this.listPageBefore(id, null);
    }

    public Page<Event> listPageBefore(long id, Integer pageSize) {
        return this.list().pageBefore(id, pageSize);
    }

    private Lister<Event> list() {
        return new Lister<Event>(new PageFetcher<Event>(this.baseUrl, "/events", this.unirest, Event.class));
    }

    public Lister<StatusChange> statusChanges(String eventKey) {
        return this.statusChanges(eventKey, null, null, null);
    }

    public Lister<StatusChange> statusChanges(String eventKey, String filter) {
        return this.statusChanges(eventKey, filter, null, null);
    }

    public Lister<StatusChange> statusChanges(String eventKey, final String filter, final String sortField, final SortDirection sortDirection) {
        PageFetcher<StatusChange> pageFetcher = new PageFetcher<StatusChange>(this.baseUrl, "/events/{key}/status-changes", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)eventKey), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("filter", filter);
                this.put("sort", Events.this.toSort(sortField, sortDirection));
            }
        }, this.unirest, StatusChange.class);
        return new Lister<StatusChange>(pageFetcher);
    }

    private String toSort(String sortField, SortDirection sortDirection) {
        if (sortField == null) {
            return null;
        }
        if (sortDirection == null) {
            return sortField;
        }
        return sortField + ":" + sortDirection.name();
    }

    public Lister<StatusChange> statusChangesForObject(String key, String objectId) {
        PageFetcher<StatusChange> pageFetcher = new PageFetcher<StatusChange>(this.baseUrl, "/events/{key}/objects/{objectId}/status-changes", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)key, (Object)"objectId", (Object)objectId), this.unirest, StatusChange.class);
        return new Lister<StatusChange>(pageFetcher);
    }

    public ChangeObjectStatusResult book(String eventKey, List<?> objects) {
        return this.book(eventKey, objects, null, null, null, null, null);
    }

    public ChangeObjectStatusResult book(String eventKey, List<?> objects, String holdToken) {
        return this.book(eventKey, objects, holdToken, null, null, null, null);
    }

    public ChangeObjectStatusResult book(String eventKey, List<?> objects, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKey, objects, "booked", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public BestAvailableResult book(String eventKey, BestAvailable bestAvailable) {
        return this.book(eventKey, bestAvailable, null, null, null, null, null);
    }

    public BestAvailableResult book(String eventKey, BestAvailable bestAvailable, String holdToken) {
        return this.book(eventKey, bestAvailable, holdToken, null, null, null, null);
    }

    public BestAvailableResult book(String eventKey, BestAvailable bestAvailable, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKey, bestAvailable, "booked", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public ChangeObjectStatusResult book(List<String> eventKeys, List<?> objects, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKeys, objects, "booked", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public ChangeObjectStatusResult hold(String eventKey, List<?> objects, String holdToken) {
        return this.hold(eventKey, objects, holdToken, null, null, null, null);
    }

    public ChangeObjectStatusResult hold(String eventKey, List<?> objects, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKey, objects, "reservedByToken", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public BestAvailableResult hold(String eventKey, BestAvailable bestAvailable, String holdToken) {
        return this.hold(eventKey, bestAvailable, holdToken, null, null, null, null);
    }

    public BestAvailableResult hold(String eventKey, BestAvailable bestAvailable, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKey, bestAvailable, "reservedByToken", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public ChangeObjectStatusResult hold(List<String> eventKeys, List<?> objects, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKeys, objects, "reservedByToken", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public ChangeObjectStatusResult release(String eventKey, List<?> objects) {
        return this.release(eventKey, objects, null, null, null, null, null);
    }

    public ChangeObjectStatusResult release(String eventKey, List<?> objects, String holdToken) {
        return this.release(eventKey, objects, holdToken, null, null, null, null);
    }

    public ChangeObjectStatusResult release(String eventKey, List<?> objects, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKey, objects, "free", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public ChangeObjectStatusResult release(List<String> eventKeys, List<?> objects, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(eventKeys, objects, "free", holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public BestAvailableResult changeObjectStatus(String eventKey, BestAvailable bestAvailable, String status) {
        return this.changeObjectStatus(eventKey, bestAvailable, status, null, null, null, null, null);
    }

    public BestAvailableResult changeObjectStatus(String eventKey, BestAvailable bestAvailable, String status, String holdToken) {
        return this.changeObjectStatus(eventKey, bestAvailable, status, holdToken, null, null, null, null);
    }

    public BestAvailableResult changeObjectStatus(String eventKey, BestAvailable bestAvailable, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        String result = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/actions/change-object-status").routeParam("key", eventKey)).body(this.changeObjectStatusRequest(bestAvailable, status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys).toString()));
        return (BestAvailableResult)SeatsioGson.gson().fromJson(result, BestAvailableResult.class);
    }

    public ChangeObjectStatusResult changeObjectStatus(String eventKey, List<?> objects, String status) {
        return this.changeObjectStatus(eventKey, objects, status, null, null, null, null, null);
    }

    public ChangeObjectStatusResult changeObjectStatus(String eventKey, List<?> objects, String status, String holdToken) {
        return this.changeObjectStatus(eventKey, objects, status, holdToken, null, null, null, null);
    }

    public ChangeObjectStatusResult changeObjectStatus(String eventKey, List<?> objects, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        return this.changeObjectStatus(Collections.singletonList(eventKey), objects, status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys);
    }

    public ChangeObjectStatusResult changeObjectStatus(String eventKey, List<?> objects, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys, Set<String> allowedPreviousStatuses, Set<String> rejectedPreviousStatuses) {
        return this.changeObjectStatus(Collections.singletonList(eventKey), objects, status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys, allowedPreviousStatuses, rejectedPreviousStatuses);
    }

    public ChangeObjectStatusResult changeObjectStatus(List<String> eventKeys, List<?> objects, String status) {
        return this.changeObjectStatus(eventKeys, objects, status, null, null, null, null, null);
    }

    public ChangeObjectStatusResult changeObjectStatus(List<String> eventKeys, List<?> objects, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        String response = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/groups/actions/change-object-status").queryString("expand", (Object)"objects")).body(this.changeObjectStatusRequest(eventKeys, this.toObjects(objects), status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys, null, null).toString()));
        return (ChangeObjectStatusResult)SeatsioGson.gson().fromJson(response, ChangeObjectStatusResult.class);
    }

    public ChangeObjectStatusResult changeObjectStatus(List<String> eventKeys, List<?> objects, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys, Set<String> allowedPreviousStatuses, Set<String> rejectedPreviousStatuses) {
        String response = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/groups/actions/change-object-status").queryString("expand", (Object)"objects")).body(this.changeObjectStatusRequest(eventKeys, this.toObjects(objects), status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys, allowedPreviousStatuses, rejectedPreviousStatuses).toString()));
        return (ChangeObjectStatusResult)SeatsioGson.gson().fromJson(response, ChangeObjectStatusResult.class);
    }

    public void overrideSeasonObjectStatus(String eventKey, List<String> objects) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{eventKey}/actions/override-season-status").routeParam("eventKey", eventKey)).body(Events.useOrOverrideSeasonObjectStatusRequest(objects).toString()));
    }

    public void useSeasonObjectStatus(String eventKey, List<String> objects) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{eventKey}/actions/use-season-status").routeParam("eventKey", eventKey)).body(Events.useOrOverrideSeasonObjectStatusRequest(objects).toString()));
    }

    private static JsonObject useOrOverrideSeasonObjectStatusRequest(List<String> objects) {
        return JsonObjectBuilder.aJsonObject().withProperty("objects", (JsonElement)JsonArrayBuilder.aJsonArray().withItems(objects.toArray(new String[0])).build()).build();
    }

    public List<ChangeObjectStatusResult> changeObjectStatus(List<StatusChangeRequest> statusChangeRequests) {
        List<JsonElement> statusChangeRequestsAsJson = statusChangeRequests.stream().map(s -> this.changeObjectStatusRequest(s.eventKey, this.toObjects(s.objects), s.status, s.holdToken, s.orderId, s.keepExtraData, s.ignoreChannels, s.channelKeys, s.allowedPreviousStatuses, s.rejectedPreviousStatuses)).collect(Collectors.toList());
        JsonObject request = JsonObjectBuilder.aJsonObject().withProperty("statusChanges", (JsonElement)JsonArrayBuilder.aJsonArray().withItems(statusChangeRequestsAsJson).build()).build();
        String response = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/actions/change-object-status").queryString("expand", (Object)"objects")).body(request.toString()));
        return ((ChangeObjectStatusInBatchResult)SeatsioGson.gson().fromJson((String)response, ChangeObjectStatusInBatchResult.class)).results;
    }

    private List<ObjectProperties> toObjects(List<?> objects) {
        return objects.stream().map(ObjectProperties::from).collect(Collectors.toList());
    }

    private JsonObject changeObjectStatusRequest(String eventKey, List<ObjectProperties> objects, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys, Set<String> allowedPreviousStatuses, Set<String> rejectedPreviousStatuses) {
        JsonObjectBuilder request = this.changeObjectStatusRequestBuilder(status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys, allowedPreviousStatuses, rejectedPreviousStatuses);
        request.withProperty("event", eventKey);
        request.withProperty("objects", objects, object -> SeatsioGson.gson().toJsonTree(object));
        return request.build();
    }

    private JsonObject changeObjectStatusRequest(List<String> eventKeys, List<ObjectProperties> objects, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys, Set<String> allowedPreviousStatuses, Set<String> rejectedPreviousStatuses) {
        JsonObjectBuilder request = this.changeObjectStatusRequestBuilder(status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys, allowedPreviousStatuses, rejectedPreviousStatuses);
        request.withProperty("events", eventKeys);
        request.withProperty("objects", objects, object -> SeatsioGson.gson().toJsonTree(object));
        return request.build();
    }

    private JsonObject changeObjectStatusRequest(BestAvailable bestAvailable, String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys) {
        JsonObjectBuilder request = this.changeObjectStatusRequestBuilder(status, holdToken, orderId, keepExtraData, ignoreChannels, channelKeys, null, null);
        request.withProperty("bestAvailable", SeatsioGson.gson().toJsonTree((Object)bestAvailable));
        return request.build();
    }

    private JsonObjectBuilder changeObjectStatusRequestBuilder(String status, String holdToken, String orderId, Boolean keepExtraData, Boolean ignoreChannels, Set<String> channelKeys, Set<String> allowedPreviousStatuses, Set<String> rejectedPreviousStatuses) {
        return JsonObjectBuilder.aJsonObject().withProperty("status", status).withPropertyIfNotNull("holdToken", holdToken).withPropertyIfNotNull("orderId", orderId).withPropertyIfNotNull("keepExtraData", keepExtraData).withPropertyIfNotNull("ignoreChannels", ignoreChannels).withPropertyIfNotNull("channelKeys", channelKeys).withPropertyIfNotNull("allowedPreviousStatuses", allowedPreviousStatuses).withPropertyIfNotNull("rejectedPreviousStatuses", rejectedPreviousStatuses);
    }

    public EventObjectInfo retrieveObjectInfo(String key, String label) {
        return this.retrieveObjectInfos(key, Lists.newArrayList((Object[])new String[]{label})).get(label);
    }

    public Map<String, EventObjectInfo> retrieveObjectInfos(String key, List<String> labels) {
        String response = this.unirest.stringResponse(((GetRequest)UnirestWrapper.get(this.baseUrl + "/events/{key}/objects").queryString("label", labels)).routeParam("key", key));
        TypeToken<Map<String, EventObjectInfo>> typeToken = new TypeToken<Map<String, EventObjectInfo>>(){};
        return (Map)SeatsioGson.gson().fromJson(response, typeToken.getType());
    }

    public void updateExtraData(String key, String object, Map<String, Object> extraData) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject();
        request.withProperty("extraData", SeatsioGson.gson().toJsonTree(extraData));
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/objects/{object}/actions/update-extra-data").routeParam("key", key)).routeParam("object", object)).body(request.build().toString()));
    }

    public void updateExtraDatas(String key, Map<String, Map<String, Object>> extraData) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject();
        request.withProperty("extraData", SeatsioGson.gson().toJsonTree(extraData));
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/actions/update-extra-data").routeParam("key", key)).body(request.build().toString()));
    }

    private static class ChangeObjectStatusInBatchResult
    extends ValueObject {
        public List<ChangeObjectStatusResult> results;

        private ChangeObjectStatusInBatchResult() {
        }
    }
}

