/*
 * Decompiled with CFR 0.152.
 */
package seatsio.reports.events;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import kong.unirest.GetRequest;
import seatsio.events.EventObjectInfo;
import seatsio.json.SeatsioGson;
import seatsio.reports.Reports;
import seatsio.reports.events.EventReportDeepSummaryItem;
import seatsio.reports.events.EventReportSummaryItem;
import seatsio.util.UnirestWrapper;

public class EventReports
extends Reports {
    private final UnirestWrapper unirest;

    public EventReports(String baseUrl, UnirestWrapper unirest) {
        super(baseUrl, "events", unirest);
        this.unirest = unirest;
    }

    public Map<String, List<EventObjectInfo>> byLabel(String eventKey) {
        return this.fetchReport("byLabel", eventKey);
    }

    public List<EventObjectInfo> byLabel(String eventKey, String label) {
        return this.fetchReportFiltered("byLabel", eventKey, label);
    }

    public Map<String, List<EventObjectInfo>> byStatus(String eventKey) {
        return this.fetchReport("byStatus", eventKey);
    }

    public List<EventObjectInfo> byStatus(String eventKey, String status) {
        return this.fetchReportFiltered("byStatus", eventKey, status);
    }

    public Map<String, EventReportSummaryItem> summaryByStatus(String eventKey) {
        return this.fetchSummaryReport("byStatus", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByStatus(String eventKey) {
        return this.fetchDeepSummaryReport("byStatus", eventKey);
    }

    public Map<String, List<EventObjectInfo>> byObjectType(String eventKey) {
        return this.fetchReport("byObjectType", eventKey);
    }

    public List<EventObjectInfo> byObjectType(String eventKey, String status) {
        return this.fetchReportFiltered("byObjectType", eventKey, status);
    }

    public Map<String, EventReportSummaryItem> summaryByObjectType(String eventKey) {
        return this.fetchSummaryReport("byObjectType", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByObjectType(String eventKey) {
        return this.fetchDeepSummaryReport("byObjectType", eventKey);
    }

    public Map<String, List<EventObjectInfo>> byCategoryLabel(String eventKey) {
        return this.fetchReport("byCategoryLabel", eventKey);
    }

    public Map<String, EventReportSummaryItem> summaryByCategoryLabel(String eventKey) {
        return this.fetchSummaryReport("byCategoryLabel", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByCategoryLabel(String eventKey) {
        return this.fetchDeepSummaryReport("byCategoryLabel", eventKey);
    }

    public List<EventObjectInfo> byCategoryLabel(String eventKey, String categoryLabel) {
        return this.fetchReportFiltered("byCategoryLabel", eventKey, categoryLabel);
    }

    public Map<String, List<EventObjectInfo>> byCategoryKey(String eventKey) {
        return this.fetchReport("byCategoryKey", eventKey);
    }

    public Map<String, EventReportSummaryItem> summaryByCategoryKey(String eventKey) {
        return this.fetchSummaryReport("byCategoryKey", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByCategoryKey(String eventKey) {
        return this.fetchDeepSummaryReport("byCategoryKey", eventKey);
    }

    public List<EventObjectInfo> byCategoryKey(String eventKey, String categoryKey) {
        return this.fetchReportFiltered("byCategoryKey", eventKey, categoryKey);
    }

    public Map<String, List<EventObjectInfo>> byOrderId(String eventKey) {
        return this.fetchReport("byOrderId", eventKey);
    }

    public List<EventObjectInfo> byOrderId(String eventKey, String orderId) {
        return this.fetchReportFiltered("byOrderId", eventKey, orderId);
    }

    public Map<String, List<EventObjectInfo>> bySection(String eventKey) {
        return this.fetchReport("bySection", eventKey);
    }

    public Map<String, EventReportSummaryItem> summaryBySection(String eventKey) {
        return this.fetchSummaryReport("bySection", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryBySection(String eventKey) {
        return this.fetchDeepSummaryReport("bySection", eventKey);
    }

    public List<EventObjectInfo> bySection(String eventKey, String section) {
        return this.fetchReportFiltered("bySection", eventKey, section);
    }

    public Map<String, List<EventObjectInfo>> byChannel(String eventKey) {
        return this.fetchReport("byChannel", eventKey);
    }

    public Map<String, EventReportSummaryItem> summaryByChannel(String channelKey) {
        return this.fetchSummaryReport("byChannel", channelKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByChannel(String channelKey) {
        return this.fetchDeepSummaryReport("byChannel", channelKey);
    }

    public List<EventObjectInfo> byChannel(String eventKey, String channelKey) {
        return this.fetchReportFiltered("byChannel", eventKey, channelKey);
    }

    public Map<String, List<EventObjectInfo>> byAvailability(String eventKey) {
        return this.fetchReport("byAvailability", eventKey);
    }

    public List<EventObjectInfo> byAvailability(String eventKey, String availability) {
        return this.fetchReportFiltered("byAvailability", eventKey, availability);
    }

    public Map<String, List<EventObjectInfo>> byAvailabilityReason(String eventKey) {
        return this.fetchReport("byAvailabilityReason", eventKey);
    }

    public List<EventObjectInfo> byAvailabilityReason(String eventKey, String availabilityReason) {
        return this.fetchReportFiltered("byAvailabilityReason", eventKey, availabilityReason);
    }

    public Map<String, EventReportSummaryItem> summaryByAvailability(String eventKey) {
        return this.fetchSummaryReport("byAvailability", eventKey);
    }

    public Map<String, EventReportSummaryItem> summaryByAvailabilityReason(String eventKey) {
        return this.fetchSummaryReport("byAvailabilityReason", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByAvailability(String eventKey) {
        return this.fetchDeepSummaryReport("byAvailability", eventKey);
    }

    public Map<String, EventReportDeepSummaryItem> deepSummaryByAvailabilityReason(String eventKey) {
        return this.fetchDeepSummaryReport("byAvailabilityReason", eventKey);
    }

    protected TypeToken<Map<String, List<EventObjectInfo>>> getTypeToken() {
        return new TypeToken<Map<String, List<EventObjectInfo>>>(){};
    }

    protected TypeToken<Map<String, EventReportSummaryItem>> getSummaryTypeToken() {
        return new TypeToken<Map<String, EventReportSummaryItem>>(){};
    }

    private Map<String, EventReportDeepSummaryItem> fetchDeepSummaryReport(String reportType, String eventKey) {
        String result = this.fetchRawDeepSummaryReport(reportType, eventKey);
        TypeToken<Map<String, EventReportDeepSummaryItem>> typeToken = new TypeToken<Map<String, EventReportDeepSummaryItem>>(){};
        return (Map)SeatsioGson.gson().fromJson(result, typeToken.getType());
    }

    private String fetchRawDeepSummaryReport(String reportType, String eventKey) {
        return this.unirest.stringResponse(((GetRequest)UnirestWrapper.get(this.baseUrl + "/reports/events/{key}/{reportType}/summary/deep").routeParam("key", eventKey)).routeParam("reportType", reportType));
    }
}

