/*
 * Decompiled with CFR 0.152.
 */
package seatsio.util;

import com.google.common.base.Charsets;
import java.util.concurrent.atomic.AtomicReference;
import kong.unirest.Config;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.RawResponse;
import kong.unirest.UnirestException;
import kong.unirest.UnirestInstance;
import seatsio.SeatsioException;

public class UnirestWrapper {
    private static UnirestInstance unirest = new UnirestInstance(new Config().concurrency(200, 200));
    private int maxRetries = 5;
    private final String secretKey;
    private final String workspaceKey;

    public UnirestWrapper(String secretKey, String workspaceKey) {
        this.secretKey = secretKey;
        this.workspaceKey = workspaceKey;
    }

    public String stringResponse(HttpRequest request) {
        byte[] response = this.execute(request, 0);
        return new String(response, Charsets.UTF_8);
    }

    public byte[] binaryResponse(HttpRequest request) {
        return this.execute(request, 0);
    }

    private byte[] execute(HttpRequest request, int retryCount) {
        try {
            AtomicReference response = new AtomicReference();
            AtomicReference responseBody = new AtomicReference();
            request.header("X-Client-Lib", "Java");
            this.authenticate(request, this.secretKey, this.workspaceKey).thenConsume(r -> {
                response.set((RawResponse)r);
                responseBody.set(((RawResponse)response.get()).getContentAsBytes());
            });
            if (retryCount >= this.maxRetries || ((RawResponse)response.get()).getStatus() != 429) {
                return this.processResponse(request, (RawResponse)response.get(), (byte[])responseBody.get());
            }
            long waitTime = (long)Math.pow(2.0, retryCount + 2) * 100L;
            UnirestWrapper.sleep(waitTime);
            return this.execute(request, ++retryCount);
        }
        catch (UnirestException e) {
            throw new SeatsioException(e, request);
        }
    }

    private byte[] processResponse(HttpRequest request, RawResponse response, byte[] responseBody) {
        if (response.getStatus() >= 400) {
            throw SeatsioException.from(request, response, responseBody);
        }
        return responseBody;
    }

    public static GetRequest get(String url) {
        return unirest.get(url);
    }

    public static HttpRequestWithBody post(String url) {
        return unirest.post(url);
    }

    public static HttpRequestWithBody delete(String url) {
        return unirest.delete(url);
    }

    private <T extends HttpRequest> T authenticate(T request, String secretKey, String workspaceKey) {
        request.basicAuth(secretKey, null);
        if (workspaceKey != null) {
            request.header("X-Workspace-Key", workspaceKey);
        }
        return request;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public UnirestWrapper maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public static void reinitializeHttpConnectionPool() {
        unirest.shutDown(false);
    }
}

