/*
 * Decompiled with CFR 0.152.
 */
package seatsio.workspaces;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import seatsio.json.JsonObjectBuilder;
import seatsio.json.SeatsioGson;
import seatsio.util.Lister;
import seatsio.util.Page;
import seatsio.util.PageFetcher;
import seatsio.util.ParameterizedLister;
import seatsio.util.UnirestWrapper;
import seatsio.workspaces.Workspace;
import seatsio.workspaces.WorkspaceLister;

public class Workspaces {
    private final String baseUrl;
    private final UnirestWrapper unirest;
    public final WorkspaceLister<Workspace> active;
    public final WorkspaceLister<Workspace> inactive;

    public Workspaces(String baseUrl, UnirestWrapper unirest) {
        this.baseUrl = baseUrl;
        this.active = new WorkspaceLister<Workspace>(new PageFetcher<Workspace>(baseUrl, "/workspaces/active", unirest, Workspace.class));
        this.inactive = new WorkspaceLister<Workspace>(new PageFetcher<Workspace>(baseUrl, "/workspaces/inactive", unirest, Workspace.class));
        this.unirest = unirest;
    }

    public Workspace create(String name) {
        return this.create(name, false);
    }

    public Workspace create(String name, Boolean isTest) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withProperty("name", name).withPropertyIfNotNull("isTest", isTest);
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.post(this.baseUrl + "/workspaces").body(request.build().toString()));
        return (Workspace)SeatsioGson.gson().fromJson(response, Workspace.class);
    }

    public void update(String key, String name) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withProperty("name", name);
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/workspaces/{key}").routeParam("key", key)).body(request.build().toString()));
    }

    public String regenerateSecretKey(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/workspaces/{key}/actions/regenerate-secret-key").routeParam("key", key));
        JsonObject result = JsonParser.parseString((String)response).getAsJsonObject();
        return result.getAsJsonPrimitive("secretKey").getAsString();
    }

    public void activate(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/workspaces/{key}/actions/activate").routeParam("key", key));
    }

    public void deactivate(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/workspaces/{key}/actions/deactivate").routeParam("key", key));
    }

    public void setDefault(String key) {
        this.unirest.stringResponse(UnirestWrapper.post(this.baseUrl + "/workspaces/actions/set-default/{key}").routeParam("key", key));
    }

    public Workspace retrieve(String key) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/workspaces/{key}").routeParam("key", key));
        return (Workspace)SeatsioGson.gson().fromJson(response, Workspace.class);
    }

    public Stream<Workspace> listAll() {
        return this.list().all();
    }

    public Stream<Workspace> listAll(String filter) {
        return this.parametrizedList().all(Workspaces.toMap(filter));
    }

    public Page<Workspace> listFirstPage() {
        return this.listFirstPage(null);
    }

    public Page<Workspace> listFirstPage(Integer pageSize) {
        return this.list().firstPage(pageSize);
    }

    public Page<Workspace> listFirstPage(Integer pageSize, String filter) {
        return this.parametrizedList().firstPage(Workspaces.toMap(filter), pageSize);
    }

    public Page<Workspace> listPageAfter(long id) {
        return this.listPageAfter(id, null);
    }

    public Page<Workspace> listPageAfter(long id, Integer pageSize) {
        return this.list().pageAfter(id, pageSize);
    }

    public Page<Workspace> listPageAfter(long id, Integer pageSize, String filter) {
        return this.parametrizedList().pageAfter(id, Workspaces.toMap(filter), pageSize);
    }

    public Page<Workspace> listPageBefore(long id) {
        return this.listPageBefore(id, null);
    }

    public Page<Workspace> listPageBefore(long id, Integer pageSize) {
        return this.list().pageBefore(id, pageSize);
    }

    public Page<Workspace> listPageBefore(long id, Integer pageSize, String filter) {
        return this.parametrizedList().pageBefore(id, Workspaces.toMap(filter), pageSize);
    }

    private Lister<Workspace> list() {
        return new Lister<Workspace>(new PageFetcher<Workspace>(this.baseUrl, "/workspaces", this.unirest, Workspace.class));
    }

    private ParameterizedLister<Workspace> parametrizedList() {
        return new ParameterizedLister<Workspace>(new PageFetcher<Workspace>(this.baseUrl, "/workspaces", this.unirest, Workspace.class));
    }

    protected static Map<String, Object> toMap(String filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (filter != null) {
            map.put("filter", filter);
        }
        return map;
    }
}

