/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.http.HttpMethod;

public class SelendroidCommandExecutor
extends HttpCommandExecutor {
    private static final String VENDOR_PREFIX = "/session/:sessionId/selendroid/";
    private static final Map<String, CommandInfo> SELENDROID_COMMANDS = new HashMap<String, CommandInfo>(){
        {
            this.put("getNetworkConnection", new CommandInfo("/session/:sessionId/network_connection", HttpMethod.GET));
            this.put("setNetworkConnection", new CommandInfo("/session/:sessionId/network_connection", HttpMethod.POST));
            this.put("actions", new CommandInfo("/session/:sessionId/actions", HttpMethod.POST));
            this.put("roll", new CommandInfo("/session/:sessionId/trackball/roll", HttpMethod.POST));
            this.put("selendroid-getBrightness", SelendroidCommandExecutor.newVendorCommand("screen/brightness", HttpMethod.GET));
            this.put("selendroid-setBrightness", SelendroidCommandExecutor.newVendorCommand("screen/brightness", HttpMethod.POST));
            this.put("selendroid-getCommandConfiguration", SelendroidCommandExecutor.newVendorCommand("configure/command/:command", HttpMethod.GET));
            this.put("selendroid-setCommandConfiguration", SelendroidCommandExecutor.newVendorCommand("configure/command/:command", HttpMethod.POST));
            this.put("selendroid-adb-sendKeyEvent", SelendroidCommandExecutor.newVendorCommand("adb/sendKeyEvent", HttpMethod.POST));
            this.put("selendroid-adb-sendText", SelendroidCommandExecutor.newVendorCommand("adb/sendText", HttpMethod.POST));
            this.put("selendroid-adb-tap", SelendroidCommandExecutor.newVendorCommand("adb/tap", HttpMethod.POST));
            this.put("selendroid-adb-executeShellCommand", SelendroidCommandExecutor.newVendorCommand("adb/executeShellCommand", HttpMethod.POST));
            this.put("selendroid-handleByExtension", SelendroidCommandExecutor.newVendorCommand("extension", HttpMethod.POST));
            this.put("backgroundApp", SelendroidCommandExecutor.newVendorCommand("background", HttpMethod.POST));
            this.put("resumeApp", SelendroidCommandExecutor.newVendorCommand("resume", HttpMethod.POST));
            this.put("addCallLog", SelendroidCommandExecutor.newVendorCommand("addCallLog", HttpMethod.POST));
            this.put("readCallLog", SelendroidCommandExecutor.newVendorCommand("readCallLog", HttpMethod.POST));
            this.put("-selendroid-forceGcExplicitly", SelendroidCommandExecutor.newVendorCommand("gc", HttpMethod.POST));
            this.put("-selendroid-setAndroidOsSystemProperty", SelendroidCommandExecutor.newVendorCommand("systemProperty", HttpMethod.POST));
        }
    };

    private static CommandInfo newVendorCommand(String path, HttpMethod method) {
        return new CommandInfo(VENDOR_PREFIX + path, method);
    }

    public SelendroidCommandExecutor(URL url) throws MalformedURLException {
        super(SELENDROID_COMMANDS, url);
    }

    public SelendroidCommandExecutor() throws MalformedURLException {
        super(SELENDROID_COMMANDS, null);
    }
}

