/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.client;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.selendroid.client.AdbSupport;
import io.selendroid.client.CallsGc;
import io.selendroid.client.Configuration;
import io.selendroid.client.DriverCommand;
import io.selendroid.client.HasMultiTouchScreen;
import io.selendroid.client.MultiTouchScreen;
import io.selendroid.client.ScreenBrightness;
import io.selendroid.client.SelendroidCommandExecutor;
import io.selendroid.client.SetsSystemProperties;
import io.selendroid.client.TrackBall;
import io.selendroid.client.adb.AdbConnection;
import io.selendroid.server.common.utils.CallLogEntry;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class SelendroidDriver
extends RemoteWebDriver
implements HasTouchScreen,
HasMultiTouchScreen,
ScreenBrightness,
Rotatable,
Configuration,
AdbSupport,
ContextAware,
SetsSystemProperties,
CallsGc {
    private RemoteTouchScreen touchScreen;
    private MultiTouchScreen multiTouchScreen;
    private RemoteAdbConnection adbConnection;
    private TrackBall trackBall;

    private SelendroidDriver(CommandExecutor executor, Capabilities caps) throws Exception {
        super(executor, caps);
        RemoteExecuteMethod executeMethod = new RemoteExecuteMethod((RemoteWebDriver)this);
        this.touchScreen = new RemoteTouchScreen((ExecuteMethod)executeMethod);
        this.multiTouchScreen = new MultiTouchScreen((ExecuteMethod)executeMethod);
        this.adbConnection = new RemoteAdbConnection((ExecuteMethod)executeMethod);
        this.trackBall = new TrackBall((ExecuteMethod)executeMethod);
    }

    public SelendroidDriver(URL url, Capabilities caps) throws Exception {
        this((CommandExecutor)new SelendroidCommandExecutor(url), caps);
    }

    public SelendroidDriver(Capabilities caps) throws Exception {
        this((CommandExecutor)new SelendroidCommandExecutor(), caps);
    }

    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    public void roll(int dimensionX, int dimensionY) {
        this.trackBall.roll(dimensionX, dimensionY);
    }

    @Override
    public MultiTouchScreen getMultiTouchScreen() {
        return this.multiTouchScreen;
    }

    @Override
    public int getBrightness() {
        Response response = this.execute("selendroid-getBrightness");
        Number value = (Number)response.getValue();
        return value.intValue();
    }

    @Override
    public void setBrightness(int desiredBrightness) {
        this.execute("selendroid-setBrightness", (Map)ImmutableMap.of((Object)"brightness", (Object)desiredBrightness));
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map)ImmutableMap.of((Object)"orientation", (Object)orientation));
    }

    public ScreenOrientation getOrientation() {
        return ScreenOrientation.valueOf((String)((String)this.execute("getScreenOrientation").getValue()));
    }

    @Override
    public void setConfiguration(DriverCommand command, String key, Object value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("command", command.command);
        parameters.put(key, value);
        this.execute("selendroid-setCommandConfiguration", parameters);
    }

    @Override
    public Map<String, Object> getConfiguration(DriverCommand command) {
        Response response = this.execute("selendroid-getCommandConfiguration", (Map)ImmutableMap.of((Object)"command", (Object)command.command));
        return (Map)response.getValue();
    }

    @Override
    public AdbConnection getAdbConnection() {
        return this.adbConnection;
    }

    public boolean isAirplaneModeEnabled() {
        return ((Number)this.execute("getNetworkConnection").getValue()).intValue() == 1;
    }

    public void setAirplaneMode(boolean enabled) {
        ImmutableMap mode = ImmutableMap.of((Object)"type", (Object)(enabled ? 1 : 6));
        this.execute("setNetworkConnection", (Map)ImmutableMap.of((Object)"parameters", (Object)mode));
    }

    public WebDriver context(String name) {
        this.execute("switchToContext", (Map)ImmutableMap.of((Object)"name", (Object)name));
        return this;
    }

    public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getContext() {
        return String.valueOf(this.execute("getCurrentContextHandle").getValue());
    }

    public void backgroundApp() {
        this.execute("backgroundApp");
    }

    public void resumeApp() {
        this.execute("resumeApp");
    }

    public void addCallLog(CallLogEntry log) {
        ImmutableMap info = ImmutableMap.of((Object)"calllogjson", (Object)log.toJSON());
        this.execute("addCallLog", (Map)ImmutableMap.of((Object)"parameters", (Object)info));
    }

    public List<CallLogEntry> readCallLog() {
        Response response = this.execute("readCallLog");
        Object value = response.getValue();
        try {
            List returnedLogs = (List)value;
            ArrayList<CallLogEntry> logEntries = new ArrayList<CallLogEntry>(returnedLogs.size());
            for (String jsonLogEntry : returnedLogs) {
                logEntries.add(CallLogEntry.fromJson((String)jsonLogEntry));
            }
            return logEntries;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public Object callExtension(String extensionMethod) {
        return this.callExtension(extensionMethod, (Map<String, ?>)ImmutableMap.of());
    }

    public Object callExtension(String extensionMethod, Map<String, ?> parameters) {
        HashMap paramsWithHandler = Maps.newHashMap();
        paramsWithHandler.putAll(parameters);
        paramsWithHandler.put("handlerName", extensionMethod);
        Response response = this.execute("selendroid-handleByExtension", paramsWithHandler);
        return response.getValue();
    }

    @Override
    public void setSystemProperty(String propertyName, String value) {
        if (Strings.isNullOrEmpty((String)propertyName)) {
            throw new IllegalArgumentException("Property name can't be empty.");
        }
        this.execute("-selendroid-setAndroidOsSystemProperty", (Map)ImmutableMap.of((Object)"propertyName", (Object)propertyName, (Object)"value", (Object)value));
    }

    @Override
    public void gc() {
        this.execute("-selendroid-forceGcExplicitly");
    }

    public class RemoteAdbConnection
    implements AdbConnection {
        private final ExecuteMethod executeMethod;

        public RemoteAdbConnection(ExecuteMethod executeMethod) {
            this.executeMethod = executeMethod;
        }

        @Override
        public void tap(int x, int y) {
            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
            parameters.put("x", x);
            parameters.put("y", y);
            this.executeMethod.execute("selendroid-adb-tap", parameters);
        }

        @Override
        public void sendText(String text) {
            this.executeMethod.execute("selendroid-adb-sendText", (Map)ImmutableMap.of((Object)"text", (Object)text));
        }

        @Override
        public void sendKeyEvent(int keyCode) {
            this.executeMethod.execute("selendroid-adb-sendKeyEvent", (Map)ImmutableMap.of((Object)"keyCode", (Object)keyCode));
        }

        @Override
        public String executeShellCommand(String command) {
            return (String)SelendroidDriver.this.execute("selendroid-adb-executeShellCommand", (Map)ImmutableMap.of((Object)"command", (Object)command)).getValue();
        }
    }
}

