/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.client.waiter;

import java.util.Set;
import java.util.concurrent.Callable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WaitingConditions {
    private WaitingConditions() {
    }

    public static Callable<WebElement> elementToExist(final WebDriver driver, final String elementId) {
        return new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                return driver.findElement(By.id((String)elementId));
            }

            public String toString() {
                return String.format("element with ID %s to exist", elementId);
            }
        };
    }

    public static Callable<String> elementTextToEqual(WebElement element, String value) {
        return new ElementTextComperator(element, value){

            @Override
            boolean compareText(String expectedValue, String actualValue) {
                return expectedValue.equals(actualValue);
            }
        };
    }

    public static Callable<String> trimmedElementTextToEqual(WebElement element, String value) {
        return new ElementTextComperator(element, value){

            @Override
            boolean compareText(String expectedValue, String actualValue) {
                return expectedValue.trim().equals(actualValue.trim());
            }
        };
    }

    public static Callable<String> elementTextToContain(WebElement element, String value) {
        return new ElementTextComperator(element, value){

            @Override
            boolean compareText(String expectedValue, String actualValue) {
                return actualValue.contains(expectedValue);
            }
        };
    }

    public static Callable<String> elementTextToEqual(final WebDriver driver, final By locator, final String value) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String text = driver.findElement(locator).getText();
                if (value.equals(text)) {
                    return text;
                }
                return null;
            }

            public String toString() {
                return "element text did not equal: " + value;
            }
        };
    }

    public static Callable<String> elementValueToEqual(final WebElement element, final String expectedValue) {
        return new Callable<String>(){
            public String lastValue = "";

            @Override
            public String call() throws Exception {
                this.lastValue = element.getAttribute("value");
                if (expectedValue.equals(this.lastValue)) {
                    return this.lastValue;
                }
                return null;
            }

            public String toString() {
                return "element value to equal: " + expectedValue + " was: " + this.lastValue;
            }
        };
    }

    public static Callable<Boolean> elementToBeHidden(final WebElement element) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return !element.isDisplayed();
                }
                catch (StaleElementReferenceException e) {
                    return true;
                }
            }
        };
    }

    public static Callable<String> pageSourceToContain(final WebDriver driver, final String expectedText) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String source = driver.getPageSource();
                if (source.contains(expectedText)) {
                    return source;
                }
                return null;
            }

            public String toString() {
                return "Page source to contain: " + expectedText;
            }
        };
    }

    public static Callable<String> pageTitleToBe(final WebDriver driver, final String expectedTitle) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String title = driver.getTitle();
                if (expectedTitle.equals(title)) {
                    return title;
                }
                return null;
            }

            public String toString() {
                return "title to be: " + expectedTitle;
            }
        };
    }

    public static Callable<String> driverUrlToBe(final WebDriver driver, final String expectedUrl) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String url = driver.getCurrentUrl();
                if (expectedUrl.equals(url)) {
                    return url;
                }
                return null;
            }

            public String toString() {
                return "url to be: " + expectedUrl;
            }
        };
    }

    public static Callable<Point> elementLocationToBe(final WebElement element, final Point expectedLocation) {
        return new Callable<Point>(){
            private Point currentLocation = new Point(0, 0);

            @Override
            public Point call() throws Exception {
                this.currentLocation = element.getLocation();
                if (this.currentLocation.equals((Object)expectedLocation)) {
                    return expectedLocation;
                }
                return null;
            }

            public String toString() {
                return "location to be: " + expectedLocation + " is: " + this.currentLocation;
            }
        };
    }

    public static Callable<WebElement> elementSelectionToBe(final WebElement element, final boolean selected) {
        return new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                if (element.isSelected() == selected) {
                    return element;
                }
                return null;
            }
        };
    }

    public static Callable<Set<String>> windowHandleCountToBe(final WebDriver driver, final int count) {
        return new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                Set handles = driver.getWindowHandles();
                if (handles.size() == count) {
                    return handles;
                }
                return null;
            }
        };
    }

    public static Callable<Alert> alertToBePresent(final WebDriver driver) {
        return new Callable<Alert>(){

            @Override
            public Alert call() throws Exception {
                try {
                    return driver.switchTo().alert();
                }
                catch (NoAlertPresentException e) {
                    return null;
                }
            }
        };
    }

    private static abstract class ElementTextComperator
    implements Callable<String> {
        private String lastText = "";
        private WebElement element;
        private String expectedValue;

        ElementTextComperator(WebElement element, String expectedValue) {
            this.element = element;
            this.expectedValue = expectedValue;
        }

        @Override
        public String call() throws Exception {
            this.lastText = this.element.getText();
            if (this.compareText(this.expectedValue, this.lastText)) {
                return this.lastText;
            }
            return null;
        }

        abstract boolean compareText(String var1, String var2);

        public String toString() {
            return "Element text mismatch: expected: " + this.expectedValue + " but was: '" + this.lastText + "'";
        }
    }
}

