/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server;

import io.selendroid.server.ServerDetails;
import org.json.JSONArray;
import org.json.JSONObject;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public class StatusServlet
implements HttpHandler {
    private ServerDetails seledendroidServer;
    private JSONArray apps = null;

    public StatusServlet(ServerDetails seledendroidServer) {
        this.seledendroidServer = seledendroidServer;
    }

    public void handleHttpRequest(HttpRequest httpRequest, HttpResponse httpResponse, HttpControl httpControl) throws Exception {
        if (!"GET".equals(httpRequest.method())) {
            httpResponse.status(500);
            httpResponse.end();
            return;
        }
        JSONObject build = new JSONObject();
        build.put("version", (Object)this.seledendroidServer.getServerVersion());
        build.put("browserName", (Object)"selendroid");
        JSONObject os = new JSONObject();
        os.put("arch", (Object)this.seledendroidServer.getCpuArch());
        os.put("name", (Object)this.seledendroidServer.getOsName());
        os.put("version", (Object)this.seledendroidServer.getOsVersion());
        JSONObject json = new JSONObject();
        json.put("build", (Object)build);
        json.put("os", (Object)os);
        JSONArray devices = null;
        try {
            devices = this.seledendroidServer.getSupportedDevices();
        }
        catch (Exception e) {
            devices = new JSONArray();
        }
        json.put("supportedDevices", (Object)devices);
        if (this.apps == null || devices.length() == 0) {
            try {
                this.apps = this.seledendroidServer.getSupportedApps();
            }
            catch (Exception e) {
                this.apps = new JSONArray();
            }
        }
        json.put("supportedApps", (Object)this.apps);
        httpResponse.header("Content-Type", "application/json");
        JSONObject result = new JSONObject();
        result.put("status", 0);
        result.put("value", (Object)json);
        httpResponse.content(result.toString());
        httpResponse.end();
    }
}

