/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server;

import io.selendroid.server.HttpResponse;
import java.nio.charset.Charset;

public class WebbitHttpResponse
implements HttpResponse {
    private final org.webbitserver.HttpResponse response;
    private boolean closed;

    public WebbitHttpResponse(org.webbitserver.HttpResponse response) {
        this.response = response;
    }

    @Override
    public void setStatus(int status) {
        this.response.status(status);
    }

    @Override
    public void setContentType(String mimeType) {
        this.response.header("Content-Type", mimeType);
    }

    @Override
    public void setContent(byte[] data) {
        this.response.header("Content-Length", (long)data.length);
        this.response.content(data);
    }

    @Override
    public void setContent(String message) {
        this.response.content(message);
    }

    @Override
    public void setEncoding(Charset charset) {
        this.response.charset(charset);
    }

    @Override
    public void sendRedirect(String to) {
        this.response.status(301);
        this.response.header("location", to);
        this.end();
    }

    @Override
    public void sendTemporaryRedirect(String to) {
        this.response.status(302);
        this.response.header("location", to);
        this.end();
    }

    @Override
    public void end() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.response.end();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

