/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Throwables;
import io.selendroid.SelendroidConfiguration;
import io.selendroid.exceptions.AndroidSdkException;
import io.selendroid.io.ShellCommand;
import io.selendroid.server.SelendroidStandaloneServer;
import io.selendroid.server.util.HttpClientUtil;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class SelendroidLauncher {
    public static final String LOGGER_NAME = "io.selendroid";
    private static final Logger log = Logger.getLogger(SelendroidLauncher.class.getName());
    private SelendroidStandaloneServer server = null;
    private SelendroidConfiguration config = null;

    public static SelendroidLauncher getInstance(String[] args) {
        try {
            SelendroidLauncher.configureLogging();
        }
        catch (Exception e1) {
            log.severe("Error occurred while registering logging file handler.");
        }
        log.info("################# Selendroid #################");
        SelendroidConfiguration config = new SelendroidConfiguration();
        try {
            new JCommander((Object)config, args);
        }
        catch (ParameterException e) {
            log.severe("An error occurred while starting selendroid: " + e.getMessage());
            System.exit(0);
        }
        if (config.isVerbose()) {
            log.setLevel(Level.FINE);
            ShellCommand.setVerbose();
        }
        SelendroidLauncher launcher = new SelendroidLauncher(config);
        return launcher;
    }

    public SelendroidLauncher(SelendroidConfiguration config) {
        this.config = config;
    }

    private void lauchServer() {
        try {
            log.info("Starting selendroid-server port " + this.config.getPort());
            this.server = new SelendroidStandaloneServer(this.config);
            this.server.start();
        }
        catch (AndroidSdkException e) {
            log.severe("Selendroid was not able to interact with the Android SDK: " + e.getMessage());
            log.severe("Please make sure you have the latest version with the latest updates installed: ");
            log.severe("http://developer.android.com/sdk/index.html");
            throw Throwables.propagate((Throwable)e);
        }
        catch (Exception e) {
            log.severe("Error occurred while building server: " + e.getMessage());
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Shutting down Selendroid standalone");
                if (SelendroidLauncher.this.server != null) {
                    SelendroidLauncher.this.server.stop();
                }
            }
        });
    }

    public void lauchSelendroid() {
        this.lauchServer();
        HttpClientUtil.waitForServer(this.config.getPort());
    }

    public static void main(String[] args) {
        try {
            SelendroidLauncher.configureLogging();
        }
        catch (Exception e1) {
            log.severe("Error occurred while registering logging file handler.");
        }
        log.info("################# Selendroid #################");
        SelendroidConfiguration config = new SelendroidConfiguration();
        try {
            new JCommander((Object)config, args);
        }
        catch (ParameterException e) {
            log.severe("An error occurred while starting selendroid: " + e.getMessage());
            System.exit(0);
        }
        if (config.isVerbose()) {
            log.setLevel(Level.FINE);
            ShellCommand.setVerbose();
        }
        SelendroidLauncher laucher = new SelendroidLauncher(config);
        laucher.lauchServer();
    }

    private static void configureLogging() throws Exception {
        FileHandler fh = new FileHandler("%h/selendroid.log", 0x200000, 1);
        fh.setFormatter(new SimpleFormatter());
        Logger.getLogger(LOGGER_NAME).addHandler(fh);
    }

    public void stopSelendroid() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

