/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.android.impl;

import com.android.ddmlib.IDevice;
import com.beust.jcommander.internal.Lists;
import io.selendroid.android.AndroidEmulator;
import io.selendroid.android.AndroidSdk;
import io.selendroid.android.TelnetClient;
import io.selendroid.android.impl.AbstractDevice;
import io.selendroid.device.DeviceTargetPlatform;
import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.exceptions.SelendroidException;
import io.selendroid.exceptions.ShellCommandException;
import io.selendroid.io.ShellCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultAndroidEmulator
extends AbstractDevice
implements AndroidEmulator {
    private static final String EMULATOR_SERIAL_PREFIX = "emulator-";
    private static final Logger log = Logger.getLogger(DefaultAndroidEmulator.class.getName());
    public static final String ANDROID_EMULATOR_HARDWARE_CONFIG = "hardware-qemu.ini";
    public static final String FILE_LOCKING_SUFIX = ".lock";
    private String screenSize;
    private DeviceTargetPlatform targetPlatform;
    private String avdName;
    private File avdRootFolder;
    private Locale locale = null;
    private boolean wasStartedBySelendroid;

    protected DefaultAndroidEmulator() {
        this.wasStartedBySelendroid = Boolean.FALSE;
    }

    public DefaultAndroidEmulator(String avdName, String abi, String screenSize, String target, File avdFilePath) {
        this.avdName = avdName;
        this.screenSize = screenSize;
        this.avdRootFolder = avdFilePath;
        this.targetPlatform = DeviceTargetPlatform.fromInt((String)target);
        this.wasStartedBySelendroid = !this.isEmulatorStarted();
    }

    @Override
    public File getAvdRootFolder() {
        return this.avdRootFolder;
    }

    @Override
    public String getScreenSize() {
        return this.screenSize;
    }

    @Override
    public DeviceTargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    public boolean isEmulatorAlreadyExistent() {
        File emulatorFolder = new File(FileUtils.getUserDirectory(), File.separator + ".android" + File.separator + "avd" + File.separator + this.getAvdName() + ".avd");
        return emulatorFolder.exists();
    }

    @Override
    public String getAvdName() {
        return this.avdName;
    }

    public static List<AndroidEmulator> listAvailableAvds() throws AndroidDeviceException {
        List avds = Lists.newArrayList();
        CommandLine cmd = new CommandLine(AndroidSdk.android());
        cmd.addArgument("list", false);
        cmd.addArgument("avds", false);
        String output = null;
        try {
            output = ShellCommand.exec(cmd, 20000L);
        }
        catch (ShellCommandException e) {
            throw new AndroidDeviceException(e);
        }
        Map<String, Integer> startedDevices = DefaultAndroidEmulator.mapDeviceNamesToSerial();
        String[] avdsOutput = StringUtils.splitByWholeSeparator((String)output, (String)"---------");
        if (avdsOutput != null && avdsOutput.length > 0) {
            for (int i = 0; i < avdsOutput.length; ++i) {
                if (!avdsOutput[i].contains("Name:")) continue;
                String element = avdsOutput[i];
                String avdName = DefaultAndroidEmulator.extractValue("Name: (.*?)$", element);
                String abi = DefaultAndroidEmulator.extractValue("ABI: (.*?)$", element);
                String screenSize = DefaultAndroidEmulator.extractValue("Skin: (.*?)$", element);
                String target = DefaultAndroidEmulator.extractValue("\\(API level (.*?)\\)", element);
                File avdFilePath = new File(DefaultAndroidEmulator.extractValue("Path: (.*?)$", element));
                DefaultAndroidEmulator emulator = new DefaultAndroidEmulator(avdName, abi, screenSize, target, avdFilePath);
                if (startedDevices.containsKey(avdName)) {
                    emulator.setSerial(startedDevices.get(avdName));
                }
                avds.add(emulator);
            }
        }
        return avds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> mapDeviceNamesToSerial() {
        Scanner scanner;
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        CommandLine command = new CommandLine(AndroidSdk.adb());
        command.addArgument("devices");
        try {
            scanner = new Scanner(ShellCommand.exec(command));
        }
        catch (ShellCommandException e) {
            return mapping;
        }
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            Pattern pattern = Pattern.compile("emulator-\\d\\d\\d\\d");
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String serial = matcher.group(0);
            Integer port = Integer.valueOf(serial.replaceAll(EMULATOR_SERIAL_PREFIX, ""));
            TelnetClient client = null;
            try {
                client = new TelnetClient(port);
                String avdName = client.sendCommand("avd name");
                mapping.put(avdName, port);
            }
            catch (AndroidDeviceException e) {
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            Socket socket = null;
            PrintWriter out = null;
            BufferedReader in = null;
            try {
                socket = new Socket("127.0.0.1", (int)port);
                out = new PrintWriter(socket.getOutputStream(), true);
                in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                if (in.readLine() == null) {
                    throw new AndroidDeviceException("error");
                }
                out.write("avd name\r\n");
                out.flush();
                in.readLine();
                String avdName = in.readLine();
                mapping.put(avdName, port);
            }
            catch (Exception e) {}
            continue;
            finally {
                try {
                    out.close();
                    in.close();
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        scanner.close();
        return mapping;
    }

    @Override
    public boolean isEmulatorStarted() {
        File lockedEmulatorHardwareConfig = new File(this.avdRootFolder, "hardware-qemu.ini.lock");
        return lockedEmulatorHardwareConfig.exists();
    }

    public String toString() {
        return "AndroidEmulator [screenSize=" + this.screenSize + ", targetPlatform=" + this.targetPlatform + ", serial=" + this.serial + ", avdName=" + this.avdName + "]";
    }

    @Override
    public void setSerial(int port) {
        this.port = port;
        this.serial = EMULATOR_SERIAL_PREFIX + port;
    }

    @Override
    public Integer getPort() {
        if (this.isSerialConfigured()) {
            return Integer.parseInt(this.serial.replace(EMULATOR_SERIAL_PREFIX, ""));
        }
        return null;
    }

    @Override
    public void start(Locale locale, int emulatorPort, Map<String, Object> options) throws AndroidDeviceException {
        if (this.isEmulatorStarted()) {
            throw new SelendroidException("Error - Android emulator is already started " + this);
        }
        Long timeout = null;
        String emulatorOptions = null;
        String display = null;
        if (options != null) {
            if (options.containsKey("TIMEOUT")) {
                timeout = (Long)options.get("TIMEOUT");
            }
            if (options.containsKey("DISPLAY")) {
                display = (String)options.get("DISPLAY");
            }
            if (options.containsKey("OPTIONS")) {
                emulatorOptions = (String)options.get("OPTIONS");
            }
        }
        if (display != null) {
            log.info("Using display " + display + " for running the emulator");
        }
        if (timeout == null) {
            timeout = 120000L;
        }
        log.info("Using timeout of '" + timeout / 1000L + "' seconds to start the emulator.");
        this.locale = locale;
        CommandLine cmd = new CommandLine(AndroidSdk.emulator());
        cmd.addArgument("-no-snapshot-save", false);
        cmd.addArgument("-avd", false);
        cmd.addArgument(this.avdName, false);
        cmd.addArgument("-port", false);
        cmd.addArgument(String.valueOf(emulatorPort), false);
        if (locale != null) {
            cmd.addArgument("-prop", false);
            cmd.addArgument("persist.sys.language=" + locale.getLanguage(), false);
            cmd.addArgument("-prop", false);
            cmd.addArgument("persist.sys.country=" + locale.getCountry(), false);
        }
        if (emulatorOptions != null && !emulatorOptions.isEmpty()) {
            cmd.addArgument(emulatorOptions, false);
        }
        long start = System.currentTimeMillis();
        long timemoutEnd = start + timeout;
        try {
            ShellCommand.execAsync(display, cmd);
        }
        catch (ShellCommandException e) {
            throw new SelendroidException("unable to start the emulator: " + this);
        }
        this.setSerial(emulatorPort);
        Boolean adbKillServerAttempted = false;
        while (!this.isDeviceReady()) {
            if (!adbKillServerAttempted.booleanValue() && System.currentTimeMillis() - start > 10000L) {
                CommandLine adbDevicesCmd = new CommandLine(AndroidSdk.adb());
                adbDevicesCmd.addArgument("devices", false);
                String devices = "";
                try {
                    devices = ShellCommand.exec(adbDevicesCmd, 20000L);
                }
                catch (ShellCommandException e) {
                    // empty catch block
                }
                if (!devices.contains(String.valueOf(emulatorPort))) {
                    CommandLine resetAdb = new CommandLine(AndroidSdk.adb());
                    resetAdb.addArgument("kill-server", false);
                    try {
                        ShellCommand.exec(resetAdb, 20000L);
                    }
                    catch (ShellCommandException e) {
                        throw new SelendroidException("unable to kill the adb server");
                    }
                }
                adbKillServerAttempted = true;
            }
            if (timemoutEnd >= System.currentTimeMillis()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            throw new AndroidDeviceException("The emulator with avd '" + this.getAvdName() + "' was not started after " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
        }
        log.info("Emulator start took: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        log.info("Please have in mind, starting an emulator takes usually about 45 seconds.");
        this.unlockEmulatorScreen();
        this.waitForLauncherToComplete();
        this.allAppsGridView();
        this.waitForLauncherToComplete();
        this.setWasStartedBySelendroid(true);
    }

    @Override
    public void unlockEmulatorScreen() throws AndroidDeviceException {
        CommandLine event82 = new CommandLine(AndroidSdk.adb());
        if (this.isSerialConfigured()) {
            event82.addArgument("-s", false);
            event82.addArgument(this.serial, false);
        }
        event82.addArgument("shell", false);
        event82.addArgument("input", false);
        event82.addArgument("keyevent", false);
        event82.addArgument("82", false);
        try {
            ShellCommand.exec(event82, 20000L);
        }
        catch (ShellCommandException e) {
            throw new AndroidDeviceException(e);
        }
        CommandLine event4 = new CommandLine(AndroidSdk.adb());
        if (this.isSerialConfigured()) {
            event4.addArgument("-s", false);
            event4.addArgument(this.serial, false);
        }
        event4.addArgument("shell", false);
        event4.addArgument("input", false);
        event4.addArgument("keyevent", false);
        event4.addArgument("4", false);
        try {
            ShellCommand.exec(event4, 20000L);
        }
        catch (ShellCommandException e) {
            throw new AndroidDeviceException(e);
        }
    }

    private void waitForLauncherToComplete() throws AndroidDeviceException {
        this.waitForLauncherToComplete(true);
    }

    private void waitForLauncherToComplete(Boolean delay) throws AndroidDeviceException {
        CommandLine event = new CommandLine(AndroidSdk.adb());
        if (this.isSerialConfigured()) {
            event.addArgument("-s", false);
            event.addArgument(this.serial, false);
        }
        event.addArgument("shell", false);
        event.addArgument("ps", false);
        String homeScreenLaunched = null;
        try {
            homeScreenLaunched = ShellCommand.exec(event, 20000L);
        }
        catch (ShellCommandException e) {
            throw new AndroidDeviceException(e);
        }
        if (homeScreenLaunched != null && homeScreenLaunched.contains("S com.android.launcher")) {
            if (!delay.booleanValue()) {
                return;
            }
        } else {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.waitForLauncherToComplete(true);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.waitForLauncherToComplete(false);
    }

    private void allAppsGridView() throws AndroidDeviceException {
        int y;
        String[] dimensions = this.screenSize.split("x");
        int x = Integer.parseInt(dimensions[0]);
        if (x > (y = Integer.parseInt(dimensions[1]))) {
            y /= 2;
            x -= 30;
        } else {
            x /= 2;
            y -= 30;
        }
        ArrayList<String> coordinates = new ArrayList<String>();
        coordinates.add("3 0 " + x);
        coordinates.add("3 1 " + y);
        coordinates.add("1 330 1");
        coordinates.add("0 0 0");
        coordinates.add("1 330 0");
        coordinates.add("0 0 0");
        for (String coordinate : coordinates) {
            CommandLine event1 = new CommandLine(AndroidSdk.adb());
            if (this.isSerialConfigured()) {
                event1.addArgument("-s", false);
                event1.addArgument(this.serial, false);
            }
            event1.addArgument("shell", false);
            event1.addArgument("sendevent", false);
            event1.addArgument("dev/input/event0", false);
            event1.addArgument(coordinate, false);
            try {
                ShellCommand.exec(event1);
            }
            catch (ShellCommandException e) {
                throw new AndroidDeviceException(e);
            }
        }
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEmulator() throws AndroidDeviceException {
        TelnetClient client = null;
        try {
            client = new TelnetClient(this.getPort());
            client.sendQuietly("kill");
        }
        catch (AndroidDeviceException androidDeviceException) {
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Override
    public void stop() throws AndroidDeviceException {
        if (this.wasStartedBySelendroid) {
            this.stopEmulator();
            Boolean killed = false;
            while (this.isEmulatorStarted()) {
                log.info("emulator still running, sleeping 0.5, waiting for it to release the lock");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                if (killed.booleanValue()) continue;
                try {
                    this.stopEmulator();
                }
                catch (AndroidDeviceException sce) {
                    killed = true;
                }
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setIDevice(IDevice iDevice) {
        this.device = iDevice;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public void setWasStartedBySelendroid(boolean wasStartedBySelendroid) {
        this.wasStartedBySelendroid = wasStartedBySelendroid;
    }
}

