/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.io;

import io.selendroid.exceptions.ShellCommandException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;

public class ShellCommand {
    private static final Logger log = Logger.getLogger(ShellCommand.class.getName());
    private static boolean verbose = false;

    public static void setVerbose() {
        verbose = true;
    }

    public static String exec(CommandLine commandLine) throws ShellCommandException {
        return ShellCommand.exec(commandLine, 20000L);
    }

    public static String exec(CommandLine commandline, long timeoutInMillies) throws ShellCommandException {
        log.info("executing command: " + commandline);
        PritingLogOutputStream outputStream = new PritingLogOutputStream();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setWatchdog(new ExecuteWatchdog(timeoutInMillies));
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)((Object)outputStream));
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            exec.execute(commandline);
        }
        catch (Exception e) {
            throw new ShellCommandException("An error occured while executing shell command: " + commandline, new ShellCommandException(outputStream.getOutput()));
        }
        return outputStream.getOutput();
    }

    public static void execAsync(CommandLine commandline) throws ShellCommandException {
        ShellCommand.execAsync(null, commandline);
    }

    public static void execAsync(String display, CommandLine commandline) throws ShellCommandException {
        log.info("executing async command: " + commandline);
        DefaultExecutor exec = new DefaultExecutor();
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)((Object)new PritingLogOutputStream()));
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        try {
            if (display == null || display.isEmpty()) {
                exec.execute(commandline, (ExecuteResultHandler)handler);
            } else {
                Map env = EnvironmentUtils.getProcEnvironment();
                EnvironmentUtils.addVariableToEnvironment((Map)env, (String)("DISPLAY=:" + display));
                exec.execute(commandline, env, (ExecuteResultHandler)handler);
            }
        }
        catch (Exception e) {
            throw new ShellCommandException("An error occured while executing shell command: " + commandline, e);
        }
    }

    private static class PritingLogOutputStream
    extends LogOutputStream {
        private StringBuilder output = new StringBuilder();

        private PritingLogOutputStream() {
        }

        protected void processLine(String line, int level) {
            if (verbose) {
                System.out.println("OUTPUT FROM PROCESS: " + line);
            }
            this.output.append(line).append("\n");
        }

        public String getOutput() {
            return this.output.toString();
        }
    }
}

