/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.handler;

import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.server.BaseSelendroidServerHandler;
import io.selendroid.server.Response;
import io.selendroid.server.SelendroidResponse;
import java.util.logging.Logger;
import org.json.JSONException;
import org.openqa.selenium.internal.Base64Encoder;
import org.webbitserver.HttpRequest;

public class CaptureScreenshot
extends BaseSelendroidServerHandler {
    private static final Logger log = Logger.getLogger(CaptureScreenshot.class.getName());

    public CaptureScreenshot(String mappedUri) {
        super(mappedUri);
    }

    public Response handle(HttpRequest request) throws JSONException {
        byte[] rawPng;
        log.info("take screenshot command");
        try {
            rawPng = this.getSelendroidDriver(request).takeScreenshot(this.getSessionId(request));
        }
        catch (AndroidDeviceException e) {
            e.printStackTrace();
            return new SelendroidResponse(this.getSessionId(request), 13, (Exception)e);
        }
        String base64Png = new Base64Encoder().encode(rawPng);
        return new SelendroidResponse(this.getSessionId(request), (Object)base64Png);
    }
}

