/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.handler;

import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.server.BaseSelendroidServerHandler;
import io.selendroid.server.Response;
import io.selendroid.server.SelendroidResponse;
import io.selendroid.server.model.SelendroidStandaloneDriver;
import java.util.logging.Logger;
import org.json.JSONException;
import org.webbitserver.HttpRequest;

public class DeleteSessionHandler
extends BaseSelendroidServerHandler {
    private static final Logger log = Logger.getLogger(DeleteSessionHandler.class.getName());

    public DeleteSessionHandler(String mappedUri) {
        super(mappedUri);
    }

    public Response handle(HttpRequest request) throws JSONException {
        log.info("delete session command");
        SelendroidStandaloneDriver driver = this.getSelendroidDriver(request);
        String sessionId = this.getSessionId(request);
        try {
            driver.stopSession(sessionId);
        }
        catch (AndroidDeviceException e) {
            log.severe("Error occured while stopping the emulator.");
        }
        return new SelendroidResponse(sessionId, (Object)"");
    }
}

