/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.handler;

import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.server.BaseSelendroidServerHandler;
import io.selendroid.server.Response;
import io.selendroid.server.UiResponse;
import io.selendroid.server.model.ActiveSession;
import java.util.logging.Logger;
import org.json.JSONException;
import org.webbitserver.HttpRequest;

public class InspectorScreenshotHandler
extends BaseSelendroidServerHandler {
    private static final Logger log = Logger.getLogger(InspectorScreenshotHandler.class.getName());

    public InspectorScreenshotHandler(String mappedUri) {
        super(mappedUri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response handle(HttpRequest request) throws JSONException {
        String sessionId = this.getSessionId(request);
        log.info("inspector screenshot handler, sessionId: " + sessionId);
        if (sessionId == null || sessionId.isEmpty()) {
            if (this.getSelendroidDriver(request).getActiveSessions() == null || this.getSelendroidDriver(request).getActiveSessions().size() < 1) return new UiResponse("", (Object)"Selendroid inspector can only be used if there is an active test session running. To start a test session, add a break point into your test code and run the test in debug mode.");
            ActiveSession session = this.getSelendroidDriver(request).getActiveSessions().get(0);
            log.info("Selected sessionId: " + session.getSessionKey());
        } else {
            ActiveSession session = this.getSelendroidDriver(request).getActiveSession(sessionId);
        }
        byte[] screenshot = null;
        try {
            screenshot = this.getSelendroidDriver(request).takeScreenshot(sessionId);
            return new UiResponse(sessionId != null ? sessionId : "", (Object)screenshot);
        }
        catch (AndroidDeviceException e) {
            e.printStackTrace();
        }
        return new UiResponse(sessionId != null ? sessionId : "", (Object)screenshot);
    }
}

