/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.handler;

import io.selendroid.exceptions.SelendroidException;
import io.selendroid.server.BaseSelendroidServerHandler;
import io.selendroid.server.JsResult;
import io.selendroid.server.Response;
import io.selendroid.server.UiResponse;
import io.selendroid.server.model.ActiveSession;
import io.selendroid.server.util.HttpClientUtil;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.json.JSONException;
import org.webbitserver.HttpRequest;

public class InspectorTreeHandler
extends BaseSelendroidServerHandler {
    private static final Logger log = Logger.getLogger(InspectorTreeHandler.class.getName());

    public InspectorTreeHandler(String mappedUri) {
        super(mappedUri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response handle(HttpRequest request) throws JSONException {
        ActiveSession session;
        String sessionId = this.getSessionId(request);
        log.info("inspector tree handler, sessionId: " + sessionId);
        if (sessionId == null || sessionId.isEmpty()) {
            if (this.getSelendroidDriver(request).getActiveSessions() == null || this.getSelendroidDriver(request).getActiveSessions().size() < 1) return new UiResponse("", (Object)"Selendroid inspector can only be used if there is an active test session running. To start a test session, add a break point into your test code and run the test in debug mode.");
            session = this.getSelendroidDriver(request).getActiveSessions().get(0);
            log.info("Selected sessionId: " + session.getSessionKey());
        } else {
            session = this.getSelendroidDriver(request).getActiveSession(sessionId);
        }
        try {
            HttpResponse r = HttpClientUtil.executeRequest("http://localhost:" + session.getSelendroidServerPort() + "/inspector/tree", HttpMethod.GET);
            return new JsResult(EntityUtils.toString((HttpEntity)r.getEntity(), (Charset)Charset.forName("UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SelendroidException((Throwable)e);
        }
    }
}

