/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.sentry.Attachment;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.Objects;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ScreenshotEventProcessor
implements EventProcessor,
Application.ActivityLifecycleCallbacks,
Closeable {
    @NotNull
    private final Application application;
    @NotNull
    private final SentryAndroidOptions options;
    @Nullable
    private WeakReference<Activity> currentActivity;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean lifecycleCallbackInstalled = true;

    public ScreenshotEventProcessor(@NotNull Application application, @NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        block10: {
            if (!this.lifecycleCallbackInstalled) {
                return event;
            }
            if (!this.options.isAttachScreenshot()) {
                this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                this.lifecycleCallbackInstalled = false;
                this.options.getLogger().log(SentryLevel.DEBUG, "attachScreenshot is disabled, ScreenshotEventProcessor isn't installed.", new Object[0]);
                return event;
            }
            if (event.isErrored() && this.currentActivity != null) {
                Activity activity = (Activity)this.currentActivity.get();
                if (this.isActivityValid(activity) && activity.getWindow() != null && activity.getWindow().getDecorView() != null && activity.getWindow().getDecorView().getRootView() != null) {
                    View view = activity.getWindow().getDecorView().getRootView();
                    if (view.getWidth() > 0 && view.getHeight() > 0) {
                        try {
                            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                            Canvas canvas = new Canvas(bitmap);
                            view.draw(canvas);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
                            if (byteArrayOutputStream.size() > 0) {
                                hint.setScreenshot(Attachment.fromScreenshot((byte[])byteArrayOutputStream.toByteArray()));
                                hint.set("android:activity", (Object)activity);
                                break block10;
                            }
                            this.options.getLogger().log(SentryLevel.DEBUG, "Screenshot is 0 bytes, not attaching the image.", new Object[0]);
                        }
                        catch (Throwable e) {
                            this.options.getLogger().log(SentryLevel.ERROR, "Taking screenshot failed.", e);
                        }
                    } else {
                        this.options.getLogger().log(SentryLevel.DEBUG, "View's width and height is zeroed, not taking screenshot.", new Object[0]);
                    }
                } else {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Activity isn't valid, not taking screenshot.", new Object[0]);
                }
            }
        }
        return event;
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.setCurrentActivity(activity);
    }

    public void onActivityStarted(@NonNull Activity activity) {
        this.setCurrentActivity(activity);
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.setCurrentActivity(activity);
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    @Override
    public void close() throws IOException {
        if (this.options.isAttachScreenshot()) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.currentActivity = null;
        }
    }

    private void cleanCurrentActivity(@NonNull Activity activity) {
        if (this.currentActivity != null && this.currentActivity.get() == activity) {
            this.currentActivity = null;
        }
    }

    private void setCurrentActivity(@NonNull Activity activity) {
        if (this.currentActivity != null && this.currentActivity.get() == activity) {
            return;
        }
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    @SuppressLint(value={"NewApi"})
    private boolean isActivityValid(@Nullable Activity activity) {
        if (activity == null) {
            return false;
        }
        if (this.buildInfoProvider.getSdkInfoVersion() >= 17) {
            return !activity.isFinishing() && !activity.isDestroyed();
        }
        return !activity.isFinishing();
    }
}

