/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Choreographer;
import android.view.FrameMetrics;
import android.view.Window;
import androidx.annotation.RequiresApi;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.util.Objects;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryFrameMetricsCollector
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final Set<Window> trackedWindows = new CopyOnWriteArraySet<Window>();
    @NotNull
    private final SentryOptions options;
    @Nullable
    private Handler handler;
    @Nullable
    private WeakReference<Window> currentWindow;
    @NotNull
    private final Map<String, FrameMetricsCollectorListener> listenerMap = new ConcurrentHashMap<String, FrameMetricsCollectorListener>();
    private boolean isAvailable = false;
    private final WindowFrameMetricsManager windowFrameMetricsManager;
    @Nullable
    private Window.OnFrameMetricsAvailableListener frameMetricsAvailableListener;
    @Nullable
    private Choreographer choreographer;
    @Nullable
    private Field choreographerLastFrameTimeField;
    private long lastFrameStartNanos = 0L;
    private long lastFrameEndNanos = 0L;

    @SuppressLint(value={"NewApi"})
    public SentryFrameMetricsCollector(@NotNull Context context, @NotNull SentryOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this(context, options, buildInfoProvider, new WindowFrameMetricsManager(){});
    }

    @SuppressLint(value={"NewApi", "DiscouragedPrivateApi"})
    public SentryFrameMetricsCollector(@NotNull Context context, @NotNull SentryOptions options, @NotNull BuildInfoProvider buildInfoProvider, @NotNull WindowFrameMetricsManager windowFrameMetricsManager) {
        Objects.requireNonNull((Object)context, (String)"The context is required");
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.windowFrameMetricsManager = (WindowFrameMetricsManager)Objects.requireNonNull((Object)windowFrameMetricsManager, (String)"WindowFrameMetricsManager is required");
        if (!(context instanceof Application)) {
            return;
        }
        if (buildInfoProvider.getSdkInfoVersion() < 24) {
            return;
        }
        this.isAvailable = true;
        HandlerThread handlerThread = new HandlerThread("io.sentry.android.core.internal.util.SentryFrameMetricsCollector");
        handlerThread.setUncaughtExceptionHandler((thread, e) -> options.getLogger().log(SentryLevel.ERROR, "Error during frames measurements.", e));
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
        ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                this.choreographer = Choreographer.getInstance();
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.ERROR, "Error retrieving Choreographer instance. Slow and frozen frames will not be reported.", e);
            }
        });
        try {
            this.choreographerLastFrameTimeField = Choreographer.class.getDeclaredField("mLastFrameTimeNanos");
            this.choreographerLastFrameTimeField.setAccessible(true);
        }
        catch (NoSuchFieldException e2) {
            options.getLogger().log(SentryLevel.ERROR, "Unable to get the frame timestamp from the choreographer: ", (Throwable)e2);
        }
        this.frameMetricsAvailableListener = (window, frameMetrics, dropCountSinceLastInvocation) -> {
            long now = System.nanoTime();
            float refreshRate = buildInfoProvider.getSdkInfoVersion() >= 30 ? window.getContext().getDisplay().getRefreshRate() : window.getWindowManager().getDefaultDisplay().getRefreshRate();
            long cpuDuration = this.getFrameCpuDuration(frameMetrics);
            long startTime = this.getFrameStartTimestamp(frameMetrics);
            if (startTime < 0L) {
                startTime = now - cpuDuration;
            }
            if ((startTime = Math.max(startTime, this.lastFrameEndNanos)) == this.lastFrameStartNanos) {
                return;
            }
            this.lastFrameStartNanos = startTime;
            this.lastFrameEndNanos = startTime + cpuDuration;
            for (FrameMetricsCollectorListener l : this.listenerMap.values()) {
                l.onFrameMetricCollected(this.lastFrameEndNanos, cpuDuration, refreshRate);
            }
        };
    }

    @SuppressLint(value={"NewApi"})
    private long getFrameStartTimestamp(@NotNull FrameMetrics frameMetrics) {
        if (this.buildInfoProvider.getSdkInfoVersion() >= 26) {
            return frameMetrics.getMetric(10);
        }
        if (this.choreographer != null && this.choreographerLastFrameTimeField != null) {
            try {
                Long choreographerFrameStartTime = (Long)this.choreographerLastFrameTimeField.get(this.choreographer);
                if (choreographerFrameStartTime != null) {
                    return choreographerFrameStartTime;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return -1L;
    }

    @RequiresApi(api=24)
    private long getFrameCpuDuration(@NotNull FrameMetrics frameMetrics) {
        return frameMetrics.getMetric(0) + frameMetrics.getMetric(1) + frameMetrics.getMetric(2) + frameMetrics.getMetric(3) + frameMetrics.getMetric(4) + frameMetrics.getMetric(5);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
    }

    public void onActivityStarted(@NotNull Activity activity) {
        this.setCurrentWindow(activity.getWindow());
    }

    public void onActivityResumed(@NotNull Activity activity) {
    }

    public void onActivityPaused(@NotNull Activity activity) {
    }

    public void onActivityStopped(@NotNull Activity activity) {
        this.stopTrackingWindow(activity.getWindow());
        if (this.currentWindow != null && this.currentWindow.get() == activity.getWindow()) {
            this.currentWindow = null;
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
    }

    @Nullable
    public String startCollection(@NotNull FrameMetricsCollectorListener listener) {
        if (!this.isAvailable) {
            return null;
        }
        String uid = UUID.randomUUID().toString();
        this.listenerMap.put(uid, listener);
        this.trackCurrentWindow();
        return uid;
    }

    public void stopCollection(@Nullable String listenerId) {
        Window window;
        if (!this.isAvailable) {
            return;
        }
        if (listenerId != null) {
            this.listenerMap.remove(listenerId);
        }
        Window window2 = window = this.currentWindow != null ? (Window)this.currentWindow.get() : null;
        if (window != null && this.listenerMap.isEmpty()) {
            this.stopTrackingWindow(window);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void stopTrackingWindow(@NotNull Window window) {
        if (this.trackedWindows.contains(window)) {
            if (this.buildInfoProvider.getSdkInfoVersion() >= 24) {
                try {
                    this.windowFrameMetricsManager.removeOnFrameMetricsAvailableListener(window, this.frameMetricsAvailableListener);
                }
                catch (Exception e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to remove frameMetricsAvailableListener", (Throwable)e);
                }
            }
            this.trackedWindows.remove(window);
        }
    }

    private void setCurrentWindow(@NotNull Window window) {
        if (this.currentWindow != null && this.currentWindow.get() == window) {
            return;
        }
        this.currentWindow = new WeakReference<Window>(window);
        this.trackCurrentWindow();
    }

    @SuppressLint(value={"NewApi"})
    private void trackCurrentWindow() {
        Window window;
        Window window2 = window = this.currentWindow != null ? (Window)this.currentWindow.get() : null;
        if (window == null || !this.isAvailable) {
            return;
        }
        if (!this.trackedWindows.contains(window) && !this.listenerMap.isEmpty() && this.buildInfoProvider.getSdkInfoVersion() >= 24 && this.handler != null) {
            this.trackedWindows.add(window);
            this.windowFrameMetricsManager.addOnFrameMetricsAvailableListener(window, this.frameMetricsAvailableListener, this.handler);
        }
    }

    @ApiStatus.Internal
    public static interface WindowFrameMetricsManager {
        @RequiresApi(api=24)
        default public void addOnFrameMetricsAvailableListener(@NotNull Window window, @Nullable Window.OnFrameMetricsAvailableListener frameMetricsAvailableListener, @Nullable Handler handler) {
            window.addOnFrameMetricsAvailableListener(frameMetricsAvailableListener, handler);
        }

        @RequiresApi(api=24)
        default public void removeOnFrameMetricsAvailableListener(@NotNull Window window, @Nullable Window.OnFrameMetricsAvailableListener frameMetricsAvailableListener) {
            window.removeOnFrameMetricsAvailableListener(frameMetricsAvailableListener);
        }
    }

    @ApiStatus.Internal
    public static interface FrameMetricsCollectorListener {
        public void onFrameMetricCollected(long var1, long var3, float var5);
    }
}

