/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.Looper;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.MeasurementUnit;
import io.sentry.SentryEvent;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.SentryTransaction;
import io.sentry.util.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PerformanceAndroidEventProcessor
implements EventProcessor {
    private static final String APP_METRICS_ORIGIN = "auto.ui";
    private static final String APP_METRICS_CONTENT_PROVIDER_OP = "contentprovider.load";
    private static final String APP_METRICS_ACTIVITIES_OP = "activity.load";
    private static final String APP_METRICS_APPLICATION_OP = "application.load";
    private static final String APP_METRICS_PROCESS_INIT_OP = "process.load";
    private static final long MAX_PROCESS_INIT_APP_START_DIFF_MS = 10000L;
    private boolean sentStartMeasurement = false;
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;
    @NotNull
    private final SentryAndroidOptions options;

    PerformanceAndroidEventProcessor(@NotNull SentryAndroidOptions options, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
    }

    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        return event;
    }

    @NotNull
    public synchronized SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        Map<String, MeasurementValue> framesMetrics;
        TimeSpan appStartTimeSpan;
        long appStartUpDurationMs;
        if (!this.options.isTracingEnabled()) {
            return transaction;
        }
        if (!this.sentStartMeasurement && this.hasAppStartSpan(transaction) && (appStartUpDurationMs = (appStartTimeSpan = AppStartMetrics.getInstance().getAppStartTimeSpanWithFallback(this.options)).getDurationMs()) != 0L) {
            MeasurementValue value = new MeasurementValue((Number)Float.valueOf(appStartUpDurationMs), MeasurementUnit.Duration.MILLISECOND.apiName());
            String appStartKey = AppStartMetrics.getInstance().getAppStartType() == AppStartMetrics.AppStartType.COLD ? "app_start_cold" : "app_start_warm";
            transaction.getMeasurements().put(appStartKey, value);
            this.attachColdAppStartSpans(AppStartMetrics.getInstance(), transaction);
            this.sentStartMeasurement = true;
        }
        SentryId eventId = transaction.getEventId();
        SpanContext spanContext = transaction.getContexts().getTrace();
        if (eventId != null && spanContext != null && spanContext.getOperation().contentEquals("ui.load") && (framesMetrics = this.activityFramesTracker.takeMetrics(eventId)) != null) {
            transaction.getMeasurements().putAll(framesMetrics);
        }
        return transaction;
    }

    private boolean hasAppStartSpan(@NotNull SentryTransaction txn) {
        @NotNull List spans = txn.getSpans();
        for (SentrySpan span : spans) {
            if (!span.getOp().contentEquals("app.start.cold") && !span.getOp().contentEquals("app.start.warm")) continue;
            return true;
        }
        @Nullable SpanContext context = txn.getContexts().getTrace();
        return context != null && (context.getOperation().equals("app.start.cold") || context.getOperation().equals("app.start.warm"));
    }

    private void attachColdAppStartSpans(@NotNull AppStartMetrics appStartMetrics, @NotNull SentryTransaction txn) {
        List<ActivityLifecycleTimeSpan> activityLifecycleTimeSpans;
        TimeSpan appOnCreate;
        List<TimeSpan> contentProviderOnCreates;
        if (appStartMetrics.getAppStartType() != AppStartMetrics.AppStartType.COLD) {
            return;
        }
        @Nullable SpanContext traceContext = txn.getContexts().getTrace();
        if (traceContext == null) {
            return;
        }
        @NotNull SentryId traceId = traceContext.getTraceId();
        SpanId parentSpanId = null;
        @NotNull List spans = txn.getSpans();
        for (SentrySpan span : spans) {
            if (!span.getOp().contentEquals("app.start.cold")) continue;
            parentSpanId = span.getSpanId();
            break;
        }
        long classInitUptimeMs = appStartMetrics.getClassLoadedUptimeMs();
        @NotNull TimeSpan appStartTimeSpan = appStartMetrics.getAppStartTimeSpan();
        if (appStartTimeSpan.hasStarted() && Math.abs(classInitUptimeMs - appStartTimeSpan.getStartUptimeMs()) <= 10000L) {
            @NotNull TimeSpan processInitTimeSpan = new TimeSpan();
            processInitTimeSpan.setStartedAt(appStartTimeSpan.getStartUptimeMs());
            processInitTimeSpan.setStartUnixTimeMs(appStartTimeSpan.getStartTimestampMs());
            processInitTimeSpan.setStoppedAt(classInitUptimeMs);
            processInitTimeSpan.setDescription("Process Initialization");
            txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(processInitTimeSpan, parentSpanId, traceId, APP_METRICS_PROCESS_INIT_OP));
        }
        if (!(contentProviderOnCreates = appStartMetrics.getContentProviderOnCreateTimeSpans()).isEmpty()) {
            for (TimeSpan contentProvider : contentProviderOnCreates) {
                txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(contentProvider, parentSpanId, traceId, APP_METRICS_CONTENT_PROVIDER_OP));
            }
        }
        if ((appOnCreate = appStartMetrics.getApplicationOnCreateTimeSpan()).hasStopped()) {
            txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(appOnCreate, parentSpanId, traceId, APP_METRICS_APPLICATION_OP));
        }
        if (!(activityLifecycleTimeSpans = appStartMetrics.getActivityLifecycleTimeSpans()).isEmpty()) {
            for (ActivityLifecycleTimeSpan activityTimeSpan : activityLifecycleTimeSpans) {
                if (activityTimeSpan.getOnCreate().hasStarted() && activityTimeSpan.getOnCreate().hasStopped()) {
                    txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(activityTimeSpan.getOnCreate(), parentSpanId, traceId, APP_METRICS_ACTIVITIES_OP));
                }
                if (!activityTimeSpan.getOnStart().hasStarted() || !activityTimeSpan.getOnStart().hasStopped()) continue;
                txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(activityTimeSpan.getOnStart(), parentSpanId, traceId, APP_METRICS_ACTIVITIES_OP));
            }
        }
    }

    @NotNull
    private static SentrySpan timeSpanToSentrySpan(@NotNull TimeSpan span, @Nullable SpanId parentSpanId, @NotNull SentryId traceId, @NotNull String operation) {
        HashMap<String, Object> defaultSpanData = new HashMap<String, Object>(2);
        defaultSpanData.put("thread.id", Looper.getMainLooper().getThread().getId());
        defaultSpanData.put("thread.name", "main");
        return new SentrySpan(Double.valueOf(span.getStartTimestampSecs()), Double.valueOf(span.getProjectedStopTimestampSecs()), traceId, new SpanId(), parentSpanId, operation, span.getDescription(), SpanStatus.OK, APP_METRICS_ORIGIN, new ConcurrentHashMap(), new ConcurrentHashMap(), defaultSpanData);
    }
}

