/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0005J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lio/sentry/android/gradle/SentryCliProvider;", "", "()V", "getCliSuffix", "", "getCliSuffix$sentry_android_gradle_plugin", "getSentryCliPath", "project", "Lorg/gradle/api/Project;", "getSentryPropertiesPath", "getSentryPropertiesPath$sentry_android_gradle_plugin", "loadCliFromResourcesToTemp", "resourcePath", "loadCliFromResourcesToTemp$sentry_android_gradle_plugin", "searchCliInPropertiesFile", "searchCliInPropertiesFile$sentry_android_gradle_plugin", "searchCliInResources", "searchCliInResources$sentry_android_gradle_plugin", "sentry-android-gradle-plugin"})
public final class SentryCliProvider {
    @NotNull
    public static final SentryCliProvider INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getSentryCliPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getLogger().info("[sentry] Searching cli from sentry.properties file...");
        String string = INSTANCE.searchCliInPropertiesFile$sentry_android_gradle_plugin(project);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            project.getLogger().info("[sentry] cli Found: " + it);
            return it;
        }
        project.getLogger().info("[sentry] sentry-cli not found in sentry.properties file");
        String cliSuffix = INSTANCE.getCliSuffix$sentry_android_gradle_plugin();
        project.getLogger().info("[sentry] cliSuffix is " + cliSuffix);
        CharSequence charSequence = cliSuffix;
        boolean bl = false;
        boolean bl4 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String resourcePath = "/bin/sentry-cli-" + cliSuffix;
            project.getLogger().info("[sentry] Searching for " + resourcePath + " in resources folder...");
            String string3 = INSTANCE.searchCliInResources$sentry_android_gradle_plugin(resourcePath);
            if (string3 != null) {
                String string4 = string3;
                bl4 = false;
                boolean bl5 = false;
                String it = string4;
                boolean bl6 = false;
                project.getLogger().info("[sentry] cli Found: " + it);
                return it;
            }
            project.getLogger().info("[sentry] Failed to load sentry-cli from resource folder");
            project.getLogger().info("[sentry] Trying to load cli from " + resourcePath + " in a temp file...");
            String string5 = INSTANCE.loadCliFromResourcesToTemp$sentry_android_gradle_plugin(resourcePath);
            if (string5 != null) {
                String string6 = string5;
                bl4 = false;
                boolean bl7 = false;
                String it = string6;
                boolean bl8 = false;
                project.getLogger().info("[sentry] cli Found: " + it);
                return it;
            }
            project.getLogger().info("[sentry] Failed to load sentry-cli from resource folder");
        }
        project.getLogger().error("[sentry] Falling back to invoking `sentry-cli` from shell");
        return "sentry-cli";
    }

    @Nullable
    public final String getSentryPropertiesPath$sentry_android_gradle_plugin(@NotNull Project project) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])new File[]{project.file((Object)"sentry.properties"), project.getRootProject().file((Object)"sentry.properties")});
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File p1 = (File)element$iv;
                boolean bl = false;
                if (!p1.exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        File file = v0;
        return file != null ? file.getPath() : null;
    }

    @Nullable
    public final String searchCliInPropertiesFile$sentry_android_gradle_plugin(@NotNull Project project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string2 = this.getSentryPropertiesPath$sentry_android_gradle_plugin(project);
        if (string2 != null) {
            Object object;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String propertiesFile = string3;
            boolean bl3 = false;
            SentryCliProvider sentryCliProvider = INSTANCE;
            boolean bl4 = false;
            try {
                object = Result.Companion;
                SentryCliProvider $this$runCatching = sentryCliProvider;
                boolean bl5 = false;
                Properties properties = new Properties();
                boolean bl6 = false;
                boolean bl7 = false;
                Properties $this$apply = properties;
                boolean bl8 = false;
                $this$apply.load(new FileInputStream(propertiesFile));
                String string4 = properties.getProperty("cli.executable");
                boolean bl9 = false;
                object = Result.constructor-impl((Object)string4);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl10 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            sentryCliProvider = object;
            bl4 = false;
            string = (String)((Object)(Result.isFailure-impl((Object)sentryCliProvider) ? null : sentryCliProvider));
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String searchCliInResources$sentry_android_gradle_plugin(@NotNull String resourcePath) {
        File resourceFile;
        URL resourceURL;
        Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
        URL uRL = resourceURL = this.getClass().getResource(resourcePath);
        if (uRL == null) return null;
        URL uRL2 = uRL;
        boolean bl = false;
        boolean bl2 = false;
        URL it = uRL2;
        boolean bl3 = false;
        File file = new File(it.getFile());
        File file2 = resourceFile = file;
        if (file2 == null) return null;
        if (!file2.exists()) return null;
        String string = resourceFile.getAbsolutePath();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String loadCliFromResourcesToTemp$sentry_android_gradle_plugin(@NotNull String resourcePath) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
        InputStream resourceStream = this.getClass().getResourceAsStream(resourcePath);
        Object object = File.createTempFile(".sentry-cli", ".exe");
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = object;
        boolean bl3 = false;
        $this$apply.deleteOnExit();
        $this$apply.setExecutable(true);
        File tempFile = object;
        if (resourceStream != null) {
            object = new FileOutputStream(tempFile);
            bl = false;
            bl2 = false;
            Throwable throwable = null;
            try {
                long l;
                FileOutputStream output = (FileOutputStream)object;
                boolean bl4 = false;
                Closeable closeable = resourceStream;
                boolean bl5 = false;
                boolean bl6 = false;
                Throwable throwable2 = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl7 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            File file = tempFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
            string = file.getAbsolutePath();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getCliSuffix$sentry_android_gradle_plugin() {
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        String osName = string5;
        String osArch = System.getProperty("os.arch");
        return StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) ? "Darwin-x86_64" : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null) ? (Intrinsics.areEqual((Object)osArch, (Object)"amd64") ? "Linux-x86_64" : "Linux-" + osArch) : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null) ? "Windows-i686.exe" : null));
    }

    private SentryCliProvider() {
    }

    static {
        SentryCliProvider sentryCliProvider;
        INSTANCE = sentryCliProvider = new SentryCliProvider();
    }
}

