/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.transforms;

import io.sentry.android.gradle.transforms.MetaInfStripTransform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lio/sentry/android/gradle/transforms/MetaInfStripTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lio/sentry/android/gradle/transforms/MetaInfStripTransform$Parameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "javaVersion", "", "Ljava/util/jar/JarEntry;", "getJavaVersion", "(Ljava/util/jar/JarEntry;)I", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "Ljava/io/File;", "Companion", "Parameters", "sentry-android-gradle-plugin"})
public abstract class MetaInfStripTransform
implements TransformAction<Parameters> {
    private static final Regex regex;
    private static final String versionsDir = "META-INF/versions/";
    private static final int MIN_SUPPORTED_JAVA_VERSION = 11;
    @NotNull
    private static final Attribute<String> artifactType;
    @NotNull
    private static final Attribute<Boolean> metaInfStripped;
    @NotNull
    public static final Companion Companion;

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkParameterIsNotNull((Object)outputs, (String)"outputs");
        Object object = this.getInputArtifact().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputArtifact.get()");
        File input = ((FileSystemLocation)object).getAsFile();
        JarFile jarFile = new JarFile(input);
        if (jarFile.isMultiRelease()) {
            StringBuilder stringBuilder = new StringBuilder();
            File file = input;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"input");
            File output = outputs.file((Object)stringBuilder.append(FilesKt.getNameWithoutExtension((File)file)).append("-meta-inf-stripped.jar").toString());
            boolean isStillMultiRelease = false;
            File file2 = output;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"output");
            Closeable closeable = this.jarOutputStream(file2);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                boolean bl3;
                int n;
                JarOutputStream outStream = (JarOutputStream)closeable;
                boolean bl4 = false;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    InputStream inputStream;
                    JarEntry jarEntry;
                    JarEntry jarEntry2 = jarEntry = entries.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry2, (String)"jarEntry");
                    if (StringsKt.equals((String)jarEntry2.getName(), (String)"META-INF/MANIFEST.MF", (boolean)true)) continue;
                    String string = jarEntry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jarEntry.name");
                    if (StringsKt.startsWith((String)string, (String)versionsDir, (boolean)true)) {
                        int javaVersion = this.getJavaVersion(jarEntry);
                        if (javaVersion > 11) continue;
                        if (javaVersion > 0) {
                            isStillMultiRelease = true;
                        }
                    }
                    outStream.putNextEntry(jarEntry);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jarFile.getInputStream(jarEntry), (String)"jarFile.getInputStream(jarEntry)");
                    n = 8192;
                    bl3 = false;
                    ByteStreamsKt.copyTo$default((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n)), (OutputStream)outStream, (int)0, (int)2, null);
                    outStream.closeEntry();
                }
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    manifest.getMainAttributes().put(Attributes.Name.MULTI_RELEASE, String.valueOf(isStillMultiRelease));
                    outStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                    OutputStream outputStream = outStream;
                    n = 8192;
                    bl3 = false;
                    manifest.write(outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n));
                    outStream.closeEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            outputs.file(this.getInputArtifact());
        }
    }

    private final int getJavaVersion(JarEntry $this$javaVersion) {
        String string = $this$javaVersion.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        Object object = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        return object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
    }

    private final JarOutputStream jarOutputStream(File $this$jarOutputStream) {
        File file = $this$jarOutputStream;
        boolean bl = false;
        return new JarOutputStream(new FileOutputStream(file));
    }

    static {
        Companion = new Companion(null);
        String string = "(?<=/)([0-9]*)(?=/)";
        boolean bl = false;
        regex = new Regex(string);
        Attribute attribute = Attribute.of((String)"artifactType", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"Attribute.of(\"artifactType\", String::class.java)");
        artifactType = attribute;
        Attribute attribute2 = Attribute.of((String)"meta-inf-stripped", Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)attribute2, (String)"Attribute.of(\"meta-inf-s\u2026an::class.javaObjectType)");
        metaInfStripped = attribute2;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/sentry/android/gradle/transforms/MetaInfStripTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "invalidate", "Lorg/gradle/api/provider/Property;", "", "getInvalidate", "()Lorg/gradle/api/provider/Property;", "sentry-android-gradle-plugin"})
    public static interface Parameters
    extends TransformParameters {
        @Input
        @Optional
        @NotNull
        public Property<Long> getInvalidate();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/sentry/android/gradle/transforms/MetaInfStripTransform$Companion;", "", "()V", "MIN_SUPPORTED_JAVA_VERSION", "", "artifactType", "Lorg/gradle/api/attributes/Attribute;", "", "getArtifactType$sentry_android_gradle_plugin", "()Lorg/gradle/api/attributes/Attribute;", "metaInfStripped", "", "getMetaInfStripped$sentry_android_gradle_plugin", "regex", "Lkotlin/text/Regex;", "versionsDir", "register", "", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "forceInstrument", "register$sentry_android_gradle_plugin", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final Attribute<String> getArtifactType$sentry_android_gradle_plugin() {
            return artifactType;
        }

        @NotNull
        public final Attribute<Boolean> getMetaInfStripped$sentry_android_gradle_plugin() {
            return metaInfStripped;
        }

        public final void register$sentry_android_gradle_plugin(@NotNull DependencyHandler dependencies, boolean forceInstrument) {
            Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
            dependencies.attributesSchema((Action)register.1.INSTANCE);
            dependencies.getArtifactTypes().named("jar", (Action)register.2.INSTANCE);
            dependencies.registerTransform(MetaInfStripTransform.class, new Action(forceInstrument){
                final /* synthetic */ boolean $forceInstrument;

                public final void execute(TransformSpec<Parameters> it) {
                    TransformSpec<Parameters> transformSpec = it;
                    Intrinsics.checkExpressionValueIsNotNull(transformSpec, (String)"it");
                    transformSpec.getFrom().attribute(MetaInfStripTransform.Companion.getArtifactType$sentry_android_gradle_plugin(), (Object)"jar").attribute(MetaInfStripTransform.Companion.getMetaInfStripped$sentry_android_gradle_plugin(), (Object)false);
                    it.getTo().attribute(MetaInfStripTransform.Companion.getArtifactType$sentry_android_gradle_plugin(), (Object)"processed-jar").attribute(MetaInfStripTransform.Companion.getMetaInfStripped$sentry_android_gradle_plugin(), (Object)true);
                    if (this.$forceInstrument) {
                        ((Parameters)it.getParameters()).getInvalidate().set((Object)System.currentTimeMillis());
                    }
                }
                {
                    this.$forceInstrument = bl;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

