/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.services;

import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import io.sentry.android.gradle.extensions.InstrumentationFeature;
import io.sentry.android.gradle.services.SentryModulesService$WhenMappings;
import io.sentry.android.gradle.util.BuildServicesKt;
import io.sentry.android.gradle.util.SemVer;
import io.sentry.android.gradle.util.SentryModules;
import io.sentry.android.gradle.util.SentryVersions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ(\u0010\u001e\u001a\u00020\u0011*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0007H\u0002R>\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR>\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006#"}, d2={"Lio/sentry/android/gradle/services/SentryModulesService;", "Lorg/gradle/api/services/BuildService;", "Lio/sentry/android/gradle/services/SentryModulesService$Parameters;", "()V", "<set-?>", "", "Lorg/gradle/api/artifacts/ModuleIdentifier;", "Lio/sentry/android/gradle/util/SemVer;", "externalModules", "getExternalModules", "()Ljava/util/Map;", "setExternalModules", "(Ljava/util/Map;)V", "sentryModules", "getSentryModules", "setSentryModules", "isComposeInstrEnabled", "", "isFileIOInstrEnabled", "isInstrumentationEnabled", "feature", "Lio/sentry/android/gradle/extensions/InstrumentationFeature;", "isLogcatInstrEnabled", "isNewDatabaseInstrEnabled", "isOkHttpInstrEnabled", "isOkHttpListenerInstrEnabled", "isOldDatabaseInstrEnabled", "retrieveEnabledInstrumentationFeatures", "", "", "isAtLeast", "module", "minVersion", "Companion", "Parameters", "sentry-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSentryModulesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryModulesService.kt\nio/sentry/android/gradle/services/SentryModulesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n766#2:134\n857#2,2:135\n1549#2:137\n1620#2,3:138\n*E\n*S KotlinDebug\n*F\n+ 1 SentryModulesService.kt\nio/sentry/android/gradle/services/SentryModulesService\n*L\n32#1:134\n32#1,2:135\n33#1:137\n33#1,3:138\n*E\n"})
public abstract class SentryModulesService
implements BuildService<Parameters> {
    @NotNull
    private Map<ModuleIdentifier, SemVer> sentryModules = MapsKt.emptyMap();
    @NotNull
    private Map<ModuleIdentifier, SemVer> externalModules = MapsKt.emptyMap();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final synchronized Map<ModuleIdentifier, SemVer> getSentryModules() {
        return this.sentryModules;
    }

    public final synchronized void setSentryModules(@NotNull Map<ModuleIdentifier, SemVer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.sentryModules = map;
    }

    @NotNull
    public final synchronized Map<ModuleIdentifier, SemVer> getExternalModules() {
        return this.externalModules;
    }

    public final synchronized void setExternalModules(@NotNull Map<ModuleIdentifier, SemVer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.externalModules = map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> retrieveEnabledInstrumentationFeatures() {
        void $this$mapTo$iv$iv;
        InstrumentationFeature it;
        Iterable $this$filterTo$iv$iv;
        Object object = ((Parameters)this.getParameters()).getFeatures().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.features.get()");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InstrumentationFeature)((Object)element$iv$iv);
            boolean bl = false;
            InstrumentationFeature instrumentationFeature = it;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)instrumentationFeature), (String)"it");
            if (!this.isInstrumentationEnabled(instrumentationFeature)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InstrumentationFeature)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getIntegrationName();
            collection.add(string);
        }
        Set features = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        if (this.isLogcatInstrEnabled()) {
            features.add("LogcatInstrumentation");
        }
        Object object2 = ((Parameters)this.getParameters()).getSourceContextEnabled().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.sourceContextEnabled.getOrElse(false)");
        if (((Boolean)object2).booleanValue()) {
            features.add("SourceContext");
        }
        return features;
    }

    private final boolean isInstrumentationEnabled(InstrumentationFeature feature) {
        boolean bl;
        switch (SentryModulesService$WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                if (this.isOldDatabaseInstrEnabled() || this.isNewDatabaseInstrEnabled()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = this.isFileIOInstrEnabled();
                break;
            }
            case 3: {
                bl = this.isOkHttpInstrEnabled();
                break;
            }
            case 4: {
                bl = this.isComposeInstrEnabled();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLogcatInstrEnabled() {
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_CORE$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_CORE");
        if (!this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_LOGCAT$sentry_android_gradle_plugin())) return false;
        Object object = ((Parameters)this.getParameters()).getLogcatEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.logcatEnabled.get()");
        if ((Boolean)object == false) return false;
        return true;
    }

    public final boolean isNewDatabaseInstrEnabled() {
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_SQLITE$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_SQLITE");
        return this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_SQLITE$sentry_android_gradle_plugin()) && ((Set)((Parameters)this.getParameters()).getFeatures().get()).contains((Object)InstrumentationFeature.DATABASE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOldDatabaseInstrEnabled() {
        if (this.isNewDatabaseInstrEnabled()) return false;
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_CORE$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_CORE");
        if (!this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_PERFORMANCE$sentry_android_gradle_plugin())) return false;
        if (!((Set)((Parameters)this.getParameters()).getFeatures().get()).contains((Object)InstrumentationFeature.DATABASE)) return false;
        return true;
    }

    public final boolean isFileIOInstrEnabled() {
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_CORE$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_CORE");
        return this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_FILE_IO$sentry_android_gradle_plugin()) && ((Set)((Parameters)this.getParameters()).getFeatures().get()).contains((Object)InstrumentationFeature.FILE_IO);
    }

    public final boolean isOkHttpListenerInstrEnabled() {
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_OKHTTP$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_OKHTTP");
        return this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_OKHTTP_LISTENER$sentry_android_gradle_plugin()) && ((Set)((Parameters)this.getParameters()).getFeatures().get()).contains((Object)InstrumentationFeature.OKHTTP);
    }

    public final boolean isOkHttpInstrEnabled() {
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_OKHTTP$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_OKHTTP");
        return this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_OKHTTP$sentry_android_gradle_plugin()) && ((Set)((Parameters)this.getParameters()).getFeatures().get()).contains((Object)InstrumentationFeature.OKHTTP);
    }

    public final boolean isComposeInstrEnabled() {
        ModuleIdentifier moduleIdentifier = SentryModules.INSTANCE.getSENTRY_ANDROID_COMPOSE$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)moduleIdentifier, (String)"SentryModules.SENTRY_ANDROID_COMPOSE");
        return this.isAtLeast(this.sentryModules, moduleIdentifier, SentryVersions.INSTANCE.getVERSION_COMPOSE$sentry_android_gradle_plugin()) && ((Set)((Parameters)this.getParameters()).getFeatures().get()).contains((Object)InstrumentationFeature.COMPOSE);
    }

    private final boolean isAtLeast(Map<ModuleIdentifier, SemVer> $this$isAtLeast, ModuleIdentifier module, SemVer minVersion) {
        return $this$isAtLeast.getOrDefault(module, SentryVersions.INSTANCE.getVERSION_DEFAULT$sentry_android_gradle_plugin()).compareTo(minVersion) >= 0;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/sentry/android/gradle/services/SentryModulesService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "features", "Lorg/gradle/api/provider/SetProperty;", "Lio/sentry/android/gradle/extensions/InstrumentationFeature;", "getFeatures", "()Lorg/gradle/api/provider/SetProperty;", "logcatEnabled", "Lorg/gradle/api/provider/Property;", "", "getLogcatEnabled", "()Lorg/gradle/api/provider/Property;", "sourceContextEnabled", "getSourceContextEnabled", "sentry-android-gradle-plugin"})
    public static interface Parameters
    extends BuildServiceParameters {
        @Input
        @NotNull
        public SetProperty<InstrumentationFeature> getFeatures();

        @Input
        @NotNull
        public Property<Boolean> getLogcatEnabled();

        @Input
        @NotNull
        public Property<Boolean> getSourceContextEnabled();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a8\u0006\u000e"}, d2={"Lio/sentry/android/gradle/services/SentryModulesService$Companion;", "", "()V", "register", "Lorg/gradle/api/provider/Provider;", "Lio/sentry/android/gradle/services/SentryModulesService;", "project", "Lorg/gradle/api/Project;", "features", "", "Lio/sentry/android/gradle/extensions/InstrumentationFeature;", "logcatEnabled", "", "sourceContextEnabled", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final Provider<SentryModulesService> register(@NotNull Project project, @NotNull Provider<Set<InstrumentationFeature>> features, @NotNull Provider<Boolean> logcatEnabled, @NotNull Provider<Boolean> sourceContextEnabled) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(features, (String)"features");
            Intrinsics.checkNotNullParameter(logcatEnabled, (String)"logcatEnabled");
            Intrinsics.checkNotNullParameter(sourceContextEnabled, (String)"sourceContextEnabled");
            Gradle gradle = project.getGradle();
            Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
            Provider provider = gradle.getSharedServices().registerIfAbsent(BuildServicesKt.getBuildServiceName(SentryModulesService.class), SentryModulesService.class, new Action(features, logcatEnabled, sourceContextEnabled){
                final /* synthetic */ Provider $features;
                final /* synthetic */ Provider $logcatEnabled;
                final /* synthetic */ Provider $sourceContextEnabled;

                public final void execute(BuildServiceSpec<Parameters> it) {
                    BuildServiceSpec<Parameters> buildServiceSpec = it;
                    Intrinsics.checkNotNullExpressionValue(buildServiceSpec, (String)"it");
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)buildServiceSpec.getParameters()).getFeatures(), (Provider)this.$features);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)it.getParameters()).getLogcatEnabled(), (Provider)this.$logcatEnabled);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)it.getParameters()).getSourceContextEnabled(), (Provider)this.$sourceContextEnabled);
                }
                {
                    this.$features = provider;
                    this.$logcatEnabled = provider2;
                    this.$sourceContextEnabled = provider3;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.gradle.sharedSer\u2026extEnabled)\n            }");
            return provider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

