/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.autoinstall;

import io.sentry.android.gradle.autoinstall.AbstractInstallStrategy;
import io.sentry.android.gradle.autoinstall.AutoInstallState;
import io.sentry.android.gradle.util.SemVer;
import io.sentry.android.gradle.util.SentryLoggingKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lio/sentry/android/gradle/autoinstall/AbstractInstallStrategy;", "Lorg/gradle/api/artifacts/ComponentMetadataRule;", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "maxSupportedThirdPartyVersion", "Lio/sentry/android/gradle/util/SemVer;", "getMaxSupportedThirdPartyVersion", "()Lio/sentry/android/gradle/util/SemVer;", "minSupportedSentryVersion", "getMinSupportedSentryVersion", "minSupportedThirdPartyVersion", "getMinSupportedThirdPartyVersion", "sentryModuleId", "", "getSentryModuleId", "()Ljava/lang/String;", "shouldInstallModule", "", "getShouldInstallModule", "()Z", "execute", "", "context", "Lorg/gradle/api/artifacts/ComponentMetadataContext;", "parseVersion", "version", "parseVersionSafely", "sentry-android-gradle-plugin"})
public abstract class AbstractInstallStrategy
implements ComponentMetadataRule {
    protected Logger logger;
    @Nullable
    private final SemVer minSupportedThirdPartyVersion;
    @Nullable
    private final SemVer maxSupportedThirdPartyVersion;
    @NotNull
    private final SemVer minSupportedSentryVersion = new SemVer(0, 0, 0, null, null, 24, null);

    @NotNull
    protected final Logger getLogger() {
        Logger logger2 = this.logger;
        if (logger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return logger2;
    }

    protected final void setLogger(@NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<set-?>");
        this.logger = logger2;
    }

    @NotNull
    protected abstract String getSentryModuleId();

    protected abstract boolean getShouldInstallModule();

    @Nullable
    protected SemVer getMinSupportedThirdPartyVersion() {
        return this.minSupportedThirdPartyVersion;
    }

    @Nullable
    protected SemVer getMaxSupportedThirdPartyVersion() {
        return this.maxSupportedThirdPartyVersion;
    }

    @NotNull
    protected SemVer getMinSupportedSentryVersion() {
        return this.minSupportedSentryVersion;
    }

    public void execute(@NotNull ComponentMetadataContext context) {
        SemVer thirdPartySemVersion;
        SemVer semVer;
        SemVer it;
        SemVer semVer2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AutoInstallState autoInstallState = AutoInstallState.Companion.getInstance$default(AutoInstallState.Companion, null, 1, null);
        if (!this.getShouldInstallModule()) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            SentryLoggingKt.info$default(logger2, null, (Function0)new Function0<String>(this){
                final /* synthetic */ AbstractInstallStrategy this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getSentryModuleId() + " won't be installed because it was already installed directly";
                }
                {
                    this.this$0 = abstractInstallStrategy;
                    super(0);
                }
            }, 1, null);
            return;
        }
        SemVer semVer3 = this.getMinSupportedThirdPartyVersion();
        if (semVer3 != null) {
            it = semVer2 = semVer3;
            boolean bl = false;
            ComponentMetadataDetails componentMetadataDetails = context.getDetails();
            Intrinsics.checkNotNullExpressionValue((Object)componentMetadataDetails, (String)"context.details");
            ModuleVersionIdentifier moduleVersionIdentifier = componentMetadataDetails.getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"context.details.id");
            String string = moduleVersionIdentifier.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.details.id.version");
            SemVer semVer4 = this.parseVersion(string);
            if (semVer4 != null) {
                thirdPartySemVersion = semVer = semVer4;
                boolean bl2 = false;
                if (thirdPartySemVersion.compareTo(it) < 0) {
                    Logger logger3 = this.logger;
                    if (logger3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    }
                    SentryLoggingKt.info$default(logger3, null, (Function0)new Function0<String>(it, this, context){
                        final /* synthetic */ SemVer $it$inlined;
                        final /* synthetic */ AbstractInstallStrategy this$0;
                        final /* synthetic */ ComponentMetadataContext $context$inlined;
                        {
                            this.$it$inlined = semVer;
                            this.this$0 = abstractInstallStrategy;
                            this.$context$inlined = componentMetadataContext;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.this$0.getSentryModuleId() + " won't be installed because the current version is lower than the minimum supported version (" + this.$it$inlined + ")";
                        }
                    }, 1, null);
                    return;
                }
            } else {
                return;
            }
        }
        SemVer semVer5 = this.getMaxSupportedThirdPartyVersion();
        if (semVer5 != null) {
            it = semVer2 = semVer5;
            boolean bl = false;
            ComponentMetadataDetails componentMetadataDetails = context.getDetails();
            Intrinsics.checkNotNullExpressionValue((Object)componentMetadataDetails, (String)"context.details");
            ModuleVersionIdentifier moduleVersionIdentifier = componentMetadataDetails.getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"context.details.id");
            String string = moduleVersionIdentifier.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.details.id.version");
            SemVer semVer6 = this.parseVersion(string);
            if (semVer6 != null) {
                thirdPartySemVersion = semVer = semVer6;
                boolean bl3 = false;
                if (thirdPartySemVersion.compareTo(it) > 0) {
                    Logger logger4 = this.logger;
                    if (logger4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    }
                    SentryLoggingKt.info$default(logger4, null, (Function0)new Function0<String>(it, this, context){
                        final /* synthetic */ SemVer $it$inlined;
                        final /* synthetic */ AbstractInstallStrategy this$0;
                        final /* synthetic */ ComponentMetadataContext $context$inlined;
                        {
                            this.$it$inlined = semVer;
                            this.this$0 = abstractInstallStrategy;
                            this.$context$inlined = componentMetadataContext;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.this$0.getSentryModuleId() + " won't be installed because the current version is higher than the maximum supported version (" + this.$it$inlined + ")";
                        }
                    }, 1, null);
                    return;
                }
            } else {
                return;
            }
        }
        if (this.getMinSupportedSentryVersion().getMajor() > 0) {
            try {
                SemVer sentrySemVersion = SemVer.Companion.parse(autoInstallState.getSentryVersion());
                if (sentrySemVersion.compareTo(this.getMinSupportedSentryVersion()) < 0) {
                    Logger logger5 = this.logger;
                    if (logger5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    }
                    SentryLoggingKt.warn$default(logger5, null, (Function0)new Function0<String>(this, autoInstallState){
                        final /* synthetic */ AbstractInstallStrategy this$0;
                        final /* synthetic */ AutoInstallState $autoInstallState;

                        @NotNull
                        public final String invoke() {
                            return this.this$0.getSentryModuleId() + " won't be installed because the current version is lower than the minimum supported sentry version (" + this.$autoInstallState + ".sentryVersion)";
                        }
                        {
                            this.this$0 = abstractInstallStrategy;
                            this.$autoInstallState = autoInstallState;
                            super(0);
                        }
                    }, 1, null);
                    return;
                }
            }
            catch (IllegalArgumentException ex) {
                Logger logger6 = this.logger;
                if (logger6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                SentryLoggingKt.warn$default(logger6, null, (Function0)new Function0<String>(this, autoInstallState){
                    final /* synthetic */ AbstractInstallStrategy this$0;
                    final /* synthetic */ AutoInstallState $autoInstallState;

                    @NotNull
                    public final String invoke() {
                        return this.this$0.getSentryModuleId() + " won't be installed because the provided sentry version(" + this.$autoInstallState + ".sentryVersion) could not be processed as a semantic version.";
                    }
                    {
                        this.this$0 = abstractInstallStrategy;
                        this.$autoInstallState = autoInstallState;
                        super(0);
                    }
                }, 1, null);
                return;
            }
        }
        context.getDetails().allVariants(new Action(this, autoInstallState){
            final /* synthetic */ AbstractInstallStrategy this$0;
            final /* synthetic */ AutoInstallState $autoInstallState;

            public final void execute(VariantMetadata metadata) {
                metadata.withDependencies(new Action(this){
                    final /* synthetic */ execute.6 this$0;

                    public final void execute(DirectDependenciesMetadata dependencies) {
                        String sentryVersion = this.this$0.$autoInstallState.getSentryVersion();
                        dependencies.add("io.sentry:" + this.this$0.this$0.getSentryModuleId() + ":" + sentryVersion);
                        SentryLoggingKt.info$default(this.this$0.this$0.getLogger(), null, (Function0)new Function0<String>(this, sentryVersion){
                            final /* synthetic */ execute.1 this$0;
                            final /* synthetic */ String $sentryVersion;

                            @NotNull
                            public final String invoke() {
                                return this.this$0.this$0.this$0.getSentryModuleId() + " was successfully installed with version: " + this.$sentryVersion;
                            }
                            {
                                this.this$0 = var1_1;
                                this.$sentryVersion = string;
                                super(0);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = abstractInstallStrategy;
                this.$autoInstallState = autoInstallState;
            }
        });
    }

    private final SemVer parseVersion(String version) {
        return this.parseVersionSafely(StringsKt.removeSuffix((String)version, (CharSequence)".RELEASE"));
    }

    private final SemVer parseVersionSafely(String version) {
        try {
            return SemVer.Companion.parse(version);
        }
        catch (Throwable t) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            SentryLoggingKt.warn$default(logger2, null, (Function0)new Function0<String>(version){
                final /* synthetic */ String $version;

                @NotNull
                public final String invoke() {
                    return "Unable to parse version " + this.$version + " as a semantic version.";
                }
                {
                    this.$version = string;
                    super(0);
                }
            }, 1, null);
            return null;
        }
    }
}

