/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.autoinstall;

import io.sentry.android.gradle.autoinstall.AutoInstallKt;
import io.sentry.android.gradle.autoinstall.AutoInstallState;
import io.sentry.android.gradle.autoinstall.InstallStrategyRegistrar;
import io.sentry.android.gradle.autoinstall.compose.ComposeInstallStrategy;
import io.sentry.android.gradle.autoinstall.fragment.FragmentInstallStrategy;
import io.sentry.android.gradle.autoinstall.graphql.GraphqlInstallStrategy;
import io.sentry.android.gradle.autoinstall.jdbc.JdbcInstallStrategy;
import io.sentry.android.gradle.autoinstall.kotlin.KotlinExtensionsInstallStrategy;
import io.sentry.android.gradle.autoinstall.log4j2.Log4j2InstallStrategy;
import io.sentry.android.gradle.autoinstall.logback.LogbackInstallStrategy;
import io.sentry.android.gradle.autoinstall.okhttp.OkHttpInstallStrategy;
import io.sentry.android.gradle.autoinstall.quartz.QuartzInstallStrategy;
import io.sentry.android.gradle.autoinstall.spring.Spring5InstallStrategy;
import io.sentry.android.gradle.autoinstall.spring.Spring6InstallStrategy;
import io.sentry.android.gradle.autoinstall.spring.SpringBoot2InstallStrategy;
import io.sentry.android.gradle.autoinstall.spring.SpringBoot3InstallStrategy;
import io.sentry.android.gradle.autoinstall.sqlite.SQLiteInstallStrategy;
import io.sentry.android.gradle.autoinstall.timber.TimberInstallStrategy;
import io.sentry.android.gradle.extensions.SentryPluginExtension;
import io.sentry.android.gradle.util.SentryLoggingKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b\u001a.\u0010\u0011\u001a\u00020\u0001*\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"SENTRY_ANDROID_CORE_ID", "", "SENTRY_ANDROID_ID", "SENTRY_GROUP", "SENTRY_JAVA_ID", "strategies", "", "Lio/sentry/android/gradle/autoinstall/InstallStrategyRegistrar;", "findSentryVersion", "Lorg/gradle/api/artifacts/DependencySet;", "isAndroid", "", "installDependencies", "", "Lorg/gradle/api/Project;", "extension", "Lio/sentry/android/gradle/extensions/SentryPluginExtension;", "installSentrySdk", "sentryVersion", "dependencies", "sentryArtifactId", "isModuleAvailable", "id", "sentry-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAutoInstall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoInstall.kt\nio/sentry/android/gradle/autoinstall/AutoInstallKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1747#2,3:144\n*E\n*S KotlinDebug\n*F\n+ 1 AutoInstall.kt\nio/sentry/android/gradle/autoinstall/AutoInstallKt\n*L\n142#1,3:144\n*E\n"})
public final class AutoInstallKt {
    @NotNull
    public static final String SENTRY_GROUP = "io.sentry";
    private static final String SENTRY_JAVA_ID = "sentry";
    private static final String SENTRY_ANDROID_ID = "sentry-android";
    private static final String SENTRY_ANDROID_CORE_ID = "sentry-android-core";
    private static final List<InstallStrategyRegistrar> strategies = CollectionsKt.listOf((Object[])new InstallStrategyRegistrar[]{OkHttpInstallStrategy.Registrar, SQLiteInstallStrategy.Registrar, TimberInstallStrategy.Registrar, FragmentInstallStrategy.Registrar, ComposeInstallStrategy.Registrar, Spring5InstallStrategy.Registrar, Spring6InstallStrategy.Registrar, SpringBoot2InstallStrategy.Registrar, SpringBoot3InstallStrategy.Registrar, LogbackInstallStrategy.Registrar, Log4j2InstallStrategy.Registrar, JdbcInstallStrategy.Registrar, GraphqlInstallStrategy.Registrar, QuartzInstallStrategy.Registrar, KotlinExtensionsInstallStrategy.Registrar});

    public static final void installDependencies(@NotNull Project $this$installDependencies, @NotNull SentryPluginExtension extension, boolean isAndroid) {
        Intrinsics.checkNotNullParameter((Object)$this$installDependencies, (String)"$this$installDependencies");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        $this$installDependencies.getConfigurations().named("implementation").configure(new Action($this$installDependencies, extension, isAndroid){
            final /* synthetic */ Project $this_installDependencies;
            final /* synthetic */ SentryPluginExtension $extension;
            final /* synthetic */ boolean $isAndroid;

            public final void execute(Configuration configuration) {
                configuration.withDependencies(new Action(this){
                    final /* synthetic */ installDependencies.1 this$0;

                    public final void execute(DependencySet dependencies) {
                        Object object = this.this$0.$extension.getAutoInstallation().getEnabled().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.autoInstallation.enabled.get()");
                        if (((Boolean)object).booleanValue()) {
                            AutoInstallState autoInstallState;
                            DependencySet dependencySet = dependencies;
                            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"dependencies");
                            String sentryVersion = AutoInstallKt.access$findSentryVersion(dependencySet, this.this$0.$isAndroid);
                            AutoInstallState $this$with = autoInstallState = AutoInstallState.Companion.getInstance(this.this$0.$this_installDependencies.getGradle());
                            boolean bl = false;
                            String sentryArtifactId = this.this$0.$isAndroid ? "sentry-android" : "sentry";
                            $this$with.setSentryVersion(AutoInstallKt.access$installSentrySdk(this.this$0.$this_installDependencies, sentryVersion, dependencies, sentryArtifactId, this.this$0.$extension));
                            $this$with.setInstallOkHttp(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-android-okhttp"));
                            $this$with.setInstallSqlite(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-android-sqlite"));
                            $this$with.setInstallTimber(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-android-timber"));
                            $this$with.setInstallFragment(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-android-fragment"));
                            $this$with.setInstallCompose(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-compose-android"));
                            $this$with.setInstallSpring(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-spring-boot") || !AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-spring-boot-jakarta") || !AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-spring") || !AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-spring-jakarta"));
                            $this$with.setInstallLogback(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-logback"));
                            $this$with.setInstallLog4j2(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-log4j2"));
                            $this$with.setInstallJdbc(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-jdbc"));
                            $this$with.setInstallGraphql(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-graphql"));
                            $this$with.setInstallQuartz(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-quartz"));
                            $this$with.setInstallKotlinExtensions(!AutoInstallKt.access$isModuleAvailable(dependencies, "sentry-kotlin-extensions"));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$this_installDependencies = project;
                this.$extension = sentryPluginExtension;
                this.$isAndroid = bl;
            }
        });
        Project project = $this$installDependencies.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getDependencies().components((Action)installDependencies.2.INSTANCE);
    }

    private static final String installSentrySdk(Project $this$installSentrySdk, String sentryVersion, DependencySet dependencies, String sentryArtifactId, SentryPluginExtension extension) {
        String string;
        if (sentryVersion == null) {
            String userDefinedVersion = (String)extension.getAutoInstallation().getSentryVersion().get();
            Dependency sentryAndroidDep = $this$installSentrySdk.getDependencies().create((Object)("io.sentry:" + sentryArtifactId + ":" + userDefinedVersion));
            dependencies.add((Object)sentryAndroidDep);
            org.gradle.api.logging.Logger logger2 = $this$installSentrySdk.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            SentryLoggingKt.info$default((Logger)logger2, null, (Function0)new Function0<String>(userDefinedVersion){
                final /* synthetic */ String $userDefinedVersion;

                @NotNull
                public final String invoke() {
                    return "sentry-android was successfully installed with version: " + this.$userDefinedVersion;
                }
                {
                    this.$userDefinedVersion = string;
                    super(0);
                }
            }, 1, null);
            String string2 = userDefinedVersion;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userDefinedVersion");
        } else {
            org.gradle.api.logging.Logger logger3 = $this$installSentrySdk.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"logger");
            SentryLoggingKt.info$default((Logger)logger3, null, installSentrySdk.2.INSTANCE, 1, null);
            string = sentryVersion;
        }
        return string;
    }

    private static final String findSentryVersion(DependencySet $this$findSentryVersion, boolean isAndroid) {
        String string;
        if (isAndroid) {
            Object v1;
            block4: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)$this$findSentryVersion;
                for (Object t : iterable2) {
                    Dependency it = (Dependency)t;
                    boolean bl = false;
                    Dependency dependency = it;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"it");
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)SENTRY_GROUP) && (Intrinsics.areEqual((Object)it.getName(), (Object)SENTRY_ANDROID_ID) || Intrinsics.areEqual((Object)it.getName(), (Object)SENTRY_ANDROID_CORE_ID)))) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            Dependency dependency = v1;
            string = dependency != null ? dependency.getVersion() : null;
        } else {
            Object v5;
            block5: {
                Iterable iterable;
                Iterable iterable3 = iterable = (Iterable)$this$findSentryVersion;
                for (Object t : iterable3) {
                    Dependency it = (Dependency)t;
                    boolean bl = false;
                    Dependency dependency = it;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"it");
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)SENTRY_GROUP) && Intrinsics.areEqual((Object)it.getName(), (Object)SENTRY_JAVA_ID))) continue;
                    v5 = t;
                    break block5;
                }
                v5 = null;
            }
            Dependency dependency = v5;
            string = dependency != null ? dependency.getVersion() : null;
        }
        return string;
    }

    private static final boolean isModuleAvailable(DependencySet $this$isModuleAvailable, String id) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)$this$isModuleAvailable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Dependency it = (Dependency)element$iv;
                    boolean bl2 = false;
                    Dependency dependency = it;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"it");
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)SENTRY_GROUP) && Intrinsics.areEqual((Object)it.getName(), (Object)id))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ String access$findSentryVersion(DependencySet $this$access_u24findSentryVersion, boolean isAndroid) {
        return AutoInstallKt.findSentryVersion($this$access_u24findSentryVersion, isAndroid);
    }

    public static final /* synthetic */ String access$installSentrySdk(Project $this$access_u24installSentrySdk, String sentryVersion, DependencySet dependencies, String sentryArtifactId, SentryPluginExtension extension) {
        return AutoInstallKt.installSentrySdk($this$access_u24installSentrySdk, sentryVersion, dependencies, sentryArtifactId, extension);
    }

    public static final /* synthetic */ boolean access$isModuleAvailable(DependencySet $this$access_u24isModuleAvailable, String id) {
        return AutoInstallKt.isModuleAvailable($this$access_u24isModuleAvailable, id);
    }

    public static final /* synthetic */ List access$getStrategies$p() {
        return strategies;
    }
}

