/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.autoinstall;

import io.sentry.android.gradle.autoinstall.AbstractInstallStrategy;
import io.sentry.android.gradle.autoinstall.AutoInstallState;
import io.sentry.android.gradle.util.SemVer;
import io.sentry.android.gradle.util.SentryLoggingKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lio/sentry/android/gradle/autoinstall/AbstractInstallStrategy;", "Lorg/gradle/api/artifacts/ComponentMetadataRule;", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "minSupportedSentryVersion", "Lio/sentry/android/gradle/util/SemVer;", "getMinSupportedSentryVersion", "()Lio/sentry/android/gradle/util/SemVer;", "minSupportedThirdPartyVersion", "getMinSupportedThirdPartyVersion", "sentryModuleId", "", "getSentryModuleId", "()Ljava/lang/String;", "shouldInstallModule", "", "getShouldInstallModule", "()Z", "execute", "", "context", "Lorg/gradle/api/artifacts/ComponentMetadataContext;", "sentry-android-gradle-plugin"})
public abstract class AbstractInstallStrategy
implements ComponentMetadataRule {
    protected Logger logger;
    @NotNull
    private final SemVer minSupportedThirdPartyVersion = new SemVer(0, 0, 0, null, null, 24, null);
    @NotNull
    private final SemVer minSupportedSentryVersion = new SemVer(0, 0, 0, null, null, 24, null);

    @NotNull
    protected final Logger getLogger() {
        Logger logger2 = this.logger;
        if (logger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return logger2;
    }

    protected final void setLogger(@NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<set-?>");
        this.logger = logger2;
    }

    @NotNull
    protected abstract String getSentryModuleId();

    protected abstract boolean getShouldInstallModule();

    @NotNull
    protected SemVer getMinSupportedThirdPartyVersion() {
        return this.minSupportedThirdPartyVersion;
    }

    @NotNull
    protected SemVer getMinSupportedSentryVersion() {
        return this.minSupportedSentryVersion;
    }

    public void execute(@NotNull ComponentMetadataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AutoInstallState autoInstallState = AutoInstallState.Companion.getInstance$default(AutoInstallState.Companion, null, 1, null);
        if (!this.getShouldInstallModule()) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            SentryLoggingKt.info$default(logger2, null, (Function0)new Function0<String>(this){
                final /* synthetic */ AbstractInstallStrategy this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getSentryModuleId() + " won't be installed because it was already installed directly";
                }
                {
                    this.this$0 = abstractInstallStrategy;
                    super(0);
                }
            }, 1, null);
            return;
        }
        ComponentMetadataDetails componentMetadataDetails = context.getDetails();
        Intrinsics.checkNotNullExpressionValue((Object)componentMetadataDetails, (String)"context.details");
        ModuleVersionIdentifier moduleVersionIdentifier = componentMetadataDetails.getId();
        Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"context.details.id");
        String string = moduleVersionIdentifier.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.details.id.version");
        SemVer thirdPartySemVersion = SemVer.Companion.parse(string);
        if (thirdPartySemVersion.compareTo(this.getMinSupportedThirdPartyVersion()) < 0) {
            Logger logger3 = this.logger;
            if (logger3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            SentryLoggingKt.warn$default(logger3, null, (Function0)new Function0<String>(this){
                final /* synthetic */ AbstractInstallStrategy this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getSentryModuleId() + " won't be installed because the current version is lower than the minimum supported version (" + this.this$0.getMinSupportedThirdPartyVersion() + ")";
                }
                {
                    this.this$0 = abstractInstallStrategy;
                    super(0);
                }
            }, 1, null);
            return;
        }
        if (this.getMinSupportedSentryVersion().getMajor() > 0) {
            try {
                SemVer sentrySemVersion = SemVer.Companion.parse(autoInstallState.getSentryVersion());
                if (sentrySemVersion.compareTo(this.getMinSupportedSentryVersion()) < 0) {
                    Logger logger4 = this.logger;
                    if (logger4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    }
                    SentryLoggingKt.warn$default(logger4, null, (Function0)new Function0<String>(this, autoInstallState){
                        final /* synthetic */ AbstractInstallStrategy this$0;
                        final /* synthetic */ AutoInstallState $autoInstallState;

                        @NotNull
                        public final String invoke() {
                            return this.this$0.getSentryModuleId() + " won't be installed because the current version is lower than the minimum supported sentry version (" + this.$autoInstallState + ".sentryVersion)";
                        }
                        {
                            this.this$0 = abstractInstallStrategy;
                            this.$autoInstallState = autoInstallState;
                            super(0);
                        }
                    }, 1, null);
                    return;
                }
            }
            catch (IllegalArgumentException ex) {
                Logger logger5 = this.logger;
                if (logger5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                SentryLoggingKt.warn$default(logger5, null, (Function0)new Function0<String>(this, autoInstallState){
                    final /* synthetic */ AbstractInstallStrategy this$0;
                    final /* synthetic */ AutoInstallState $autoInstallState;

                    @NotNull
                    public final String invoke() {
                        return this.this$0.getSentryModuleId() + " won't be installed because the provided sentry version(" + this.$autoInstallState + ".sentryVersion) could not be processed as a semantic version.";
                    }
                    {
                        this.this$0 = abstractInstallStrategy;
                        this.$autoInstallState = autoInstallState;
                        super(0);
                    }
                }, 1, null);
                return;
            }
        }
        context.getDetails().allVariants(new Action(this, autoInstallState){
            final /* synthetic */ AbstractInstallStrategy this$0;
            final /* synthetic */ AutoInstallState $autoInstallState;

            public final void execute(VariantMetadata metadata) {
                metadata.withDependencies(new Action(this){
                    final /* synthetic */ execute.5 this$0;

                    public final void execute(DirectDependenciesMetadata dependencies) {
                        String sentryVersion = this.this$0.$autoInstallState.getSentryVersion();
                        dependencies.add("io.sentry:" + this.this$0.this$0.getSentryModuleId() + ":" + sentryVersion);
                        SentryLoggingKt.info$default(this.this$0.this$0.getLogger(), null, (Function0)new Function0<String>(this, sentryVersion){
                            final /* synthetic */ execute.1 this$0;
                            final /* synthetic */ String $sentryVersion;

                            @NotNull
                            public final String invoke() {
                                return this.this$0.this$0.this$0.getSentryModuleId() + " was successfully installed with version: " + this.$sentryVersion;
                            }
                            {
                                this.this$0 = var1_1;
                                this.$sentryVersion = string;
                                super(0);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = abstractInstallStrategy;
                this.$autoInstallState = autoInstallState;
            }
        });
    }
}

