/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.tasks;

import io.sentry.android.gradle.util.ArtifactUtilsKt;
import io.sentry.android.gradle.util.GradleVersions;
import io.sentry.android.gradle.util.SentryPluginUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/sentry/android/gradle/tasks/SentryExternalDependenciesReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "attributeValueJar", "Lorg/gradle/api/provider/Property;", "", "getAttributeValueJar", "()Lorg/gradle/api/provider/Property;", "includeReport", "", "getIncludeReport", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "runtimeConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "action", "", "getRuntimeClasspath", "Lorg/gradle/api/file/FileCollection;", "setRuntimeConfiguration", "configuration", "sentry-android-gradle-plugin"})
public abstract class SentryExternalDependenciesReportTask
extends DefaultTask {
    private transient Configuration runtimeConfiguration;

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeReport();

    public final void setRuntimeConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.runtimeConfiguration = configuration;
    }

    @Input
    @NotNull
    public abstract Property<String> getAttributeValueJar();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getRuntimeClasspath() {
        Configuration configuration = this.runtimeConfiguration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeConfiguration");
        }
        Object object = this.getAttributeValueJar().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attributeValueJar.get()");
        FileCollection fileCollection = ArtifactUtilsKt.artifactsFor(configuration, (String)object);
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"runtimeConfiguration.art\u2026ibuteValueJar.get()\n    )");
        return fileCollection;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$mapTo$iv$iv;
        ResolvedComponentResult it;
        Iterable $this$filterTo$iv$iv;
        File outputFile = SentryPluginUtils.INSTANCE.getAndDeleteFile((Provider<RegularFile>)((Provider)this.getOutput()));
        outputFile.getParentFile().mkdirs();
        Configuration configuration = this.runtimeConfiguration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeConfiguration");
        }
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"runtimeConfiguration\n            .incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionResult, (String)"runtimeConfiguration\n   \u2026        .resolutionResult");
        Set set = resolutionResult.getAllComponents();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"runtimeConfiguration\n   \u2026           .allComponents");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResolvedComponentResult)element$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"it");
            if (!(resolvedComponentResult.getId() instanceof ModuleComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CharSequence charSequence;
            it = (ResolvedComponentResult)element$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"it");
            Object object = resolvedComponentResult.getModuleVersion();
            if (!(object != null && (object = object.getVersion()) != null && (charSequence = (CharSequence)object).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResolvedComponentResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"it");
            ComponentIdentifier componentIdentifier = resolvedComponentResult.getId();
            Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"it.id");
            String string = componentIdentifier.getDisplayName();
            collection.add(string);
        }
        SortedSet dependencies = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        FilesKt.writeText$default((File)outputFile, (String)CollectionsKt.joinToString$default((Iterable)dependencies, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    public SentryExternalDependenciesReportTask() {
        this.setDescription("Generates an external dependencies report");
        if (GradleVersions.INSTANCE.getCURRENT().compareTo(GradleVersions.INSTANCE.getVERSION_7_4()) >= 0) {
            this.notCompatibleWithConfigurationCache("Cannot serialize Configurations");
        }
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = this.getIncludeReport().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeReport.get()");
                return (Boolean)object;
            }
        });
    }
}

