/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.util;

import io.sentry.android.gradle.services.SentryModulesService;
import io.sentry.android.gradle.util.SemVer;
import io.sentry.android.gradle.util.SentryAndroidSdkCheckerKt;
import io.sentry.android.gradle.util.SentryLoggingKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"detectSentryAndroidSdk", "", "Lorg/gradle/api/Project;", "configurationName", "", "variantName", "sentryModulesService", "Lorg/gradle/api/provider/Provider;", "Lio/sentry/android/gradle/services/SentryModulesService;", "filterSentryModules", "", "Lio/sentry/android/gradle/util/SemVer;", "", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "logger", "Lorg/gradle/api/logging/Logger;", "sentry-android-gradle-plugin"})
public final class SentryAndroidSdkCheckerKt {
    public static final void detectSentryAndroidSdk(@NotNull Project $this$detectSentryAndroidSdk, @NotNull String configurationName, @NotNull String variantName, @NotNull Provider<SentryModulesService> sentryModulesService) {
        NamedDomainObjectProvider namedDomainObjectProvider;
        Intrinsics.checkNotNullParameter((Object)$this$detectSentryAndroidSdk, (String)"$this$detectSentryAndroidSdk");
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter(sentryModulesService, (String)"sentryModulesService");
        try {
            namedDomainObjectProvider = $this$detectSentryAndroidSdk.getConfigurations().named(configurationName);
        }
        catch (UnknownDomainObjectException e) {
            org.gradle.api.logging.Logger logger2 = $this$detectSentryAndroidSdk.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            SentryLoggingKt.warn$default((Logger)logger2, null, (Function0)new Function0<String>(configurationName, variantName){
                final /* synthetic */ String $configurationName;
                final /* synthetic */ String $variantName;

                @NotNull
                public final String invoke() {
                    return "Unable to find configuration " + this.$configurationName + " for variant " + this.$variantName + ".";
                }
                {
                    this.$configurationName = string;
                    this.$variantName = string2;
                    super(0);
                }
            }, 1, null);
            ((SentryModulesService)sentryModulesService.get()).setModules(MapsKt.emptyMap());
            return;
        }
        NamedDomainObjectProvider configProvider2 = namedDomainObjectProvider;
        configProvider2.configure(new Action($this$detectSentryAndroidSdk, variantName, configurationName, sentryModulesService){
            final /* synthetic */ Project $this_detectSentryAndroidSdk;
            final /* synthetic */ String $variantName;
            final /* synthetic */ String $configurationName;
            final /* synthetic */ Provider $sentryModulesService;

            public final void execute(Configuration configuration) {
                Configuration configuration2 = configuration;
                Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
                configuration2.getIncoming().afterResolve(new Action(this){
                    final /* synthetic */ detectSentryAndroidSdk.1 this$0;

                    public final void execute(ResolvableDependencies it) {
                        ResolvableDependencies resolvableDependencies = it;
                        Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"it");
                        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
                        Intrinsics.checkNotNullExpressionValue((Object)resolutionResult, (String)"it.resolutionResult");
                        Set set = resolutionResult.getAllComponents();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.resolutionResult.allComponents");
                        org.gradle.api.logging.Logger logger2 = this.this$0.$this_detectSentryAndroidSdk.getLogger();
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
                        Map sentryModules = SentryAndroidSdkCheckerKt.access$filterSentryModules(set, logger2);
                        org.gradle.api.logging.Logger logger3 = this.this$0.$this_detectSentryAndroidSdk.getLogger();
                        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"logger");
                        SentryLoggingKt.info$default((Logger)logger3, null, (Function0)new Function0<String>(this, sentryModules){
                            final /* synthetic */ detectSentryAndroidSdk.1 this$0;
                            final /* synthetic */ Map $sentryModules;

                            @NotNull
                            public final String invoke() {
                                return "Detected Sentry modules " + this.$sentryModules + " for variant: " + this.this$0.this$0.$variantName + ", config: " + this.this$0.this$0.$configurationName;
                            }
                            {
                                this.this$0 = var1_1;
                                this.$sentryModules = map;
                                super(0);
                            }
                        }, 1, null);
                        ((SentryModulesService)this.this$0.$sentryModulesService.get()).setModules(sentryModules);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$this_detectSentryAndroidSdk = project;
                this.$variantName = string;
                this.$configurationName = string2;
                this.$sentryModulesService = provider;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, SemVer> filterSentryModules(Set<? extends ResolvedComponentResult> $this$filterSentryModules, org.gradle.api.logging.Logger logger2) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterSentryModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            ResolvedComponentResult resolvedComponent = (ResolvedComponentResult)element$iv$iv;
            boolean bl2 = false;
            if (resolvedComponent.getModuleVersion() == null) {
                bl = false;
            } else {
                ModuleVersionIdentifier moduleVersion;
                Intrinsics.checkNotNullExpressionValue((Object)moduleVersion, (String)"resolvedComponent.module\u2026on ?: return@filter false");
                bl = Intrinsics.areEqual((Object)moduleVersion.getGroup(), (Object)"io.sentry");
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            SemVer semVer;
            Object object;
            Object name;
            Map map = destination$iv$iv2;
            ResolvedComponentResult it = (ResolvedComponentResult)element$iv$iv;
            boolean bl = false;
            Object object2 = it.getModuleVersion();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = name = "";
            }
            if ((object = it.getModuleVersion()) == null || (object = object.getVersion()) == null) {
                object = "";
            }
            Object version = object;
            try {
                semVer = SemVer.Companion.parse((String)version);
            }
            catch (Throwable e) {
                SentryLoggingKt.info$default((Logger)logger2, null, (Function0)new Function0<String>((String)version, (String)name){
                    final /* synthetic */ String $version;
                    final /* synthetic */ String $name;

                    @NotNull
                    public final String invoke() {
                        return "Unable to parse version " + this.$version + " of " + this.$name;
                    }
                    {
                        this.$version = string;
                        this.$name = string2;
                        super(0);
                    }
                }, 1, null);
                semVer = new SemVer(0, 0, 0, null, null, 31, null);
            }
            SemVer semver2 = semVer;
            Pair pair = TuplesKt.to((Object)name, (Object)semver2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    public static final /* synthetic */ Map access$filterSentryModules(Set $this$access_u24filterSentryModules, org.gradle.api.logging.Logger logger2) {
        return SentryAndroidSdkCheckerKt.filterSentryModules($this$access_u24filterSentryModules, logger2);
    }
}

