/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import io.sentry.android.gradle.AndroidVariant70;
import io.sentry.android.gradle.AppConfigKt;
import io.sentry.android.gradle.SentryPlugin;
import io.sentry.android.gradle.SentryPropertiesFileProvider;
import io.sentry.android.gradle.SentryTasksProvider;
import io.sentry.android.gradle.extensions.SentryPluginExtension;
import io.sentry.android.gradle.tasks.DirectoryOutputTask;
import io.sentry.android.gradle.tasks.SentryGenerateProguardUuidTask;
import io.sentry.android.gradle.tasks.SentryUploadNativeSymbolsTask;
import io.sentry.android.gradle.tasks.SentryUploadProguardMappingsTask;
import io.sentry.android.gradle.tasks.dependencies.SentryExternalDependenciesReportTaskFactory;
import io.sentry.android.gradle.util.AgpVersions;
import io.sentry.android.gradle.util.SentryLoggingKt;
import io.sentry.android.gradle.util.SentryPluginUtils;
import io.sentry.android.gradle.util.TasksKt;
import io.sentry.gradle.common.AndroidVariant;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b\u001a<\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0016\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u00100\u000fH\u0002\u001a8\u0010\u0012\u001a\u00020\u0001*\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002\u001aX\u0010\u0014\u001a\u00020\u0001*\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0016\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002\u001a,\u0010\u0015\u001a\u00020\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0016\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u00100\u000fH\u0002\u00a8\u0006\u0016"}, d2={"configure", "", "Lcom/android/build/gradle/AppExtension;", "project", "Lorg/gradle/api/Project;", "extension", "Lio/sentry/android/gradle/extensions/SentryPluginExtension;", "cliExecutable", "", "sentryOrg", "sentryProject", "configureDependenciesTask", "Lcom/android/build/gradle/api/BaseVariant;", "appExtension", "dependants", "", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "configureNativeSymbolsTask", "Lcom/android/build/gradle/api/ApplicationVariant;", "configureProguardMappingsTasks", "setupMergeAssetsDependencies", "sentry-android-gradle-plugin"})
public final class AppConfigKt {
    public static final void configure(@NotNull AppExtension $this$configure, @NotNull Project project, @NotNull SentryPluginExtension extension, @NotNull String cliExecutable, @Nullable String sentryOrg, @Nullable String sentryProject) {
        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)cliExecutable, (String)"cliExecutable");
        $this$configure.getApplicationVariants().matching(new Spec(extension){
            final /* synthetic */ SentryPluginExtension $extension;

            public final boolean isSatisfiedBy(ApplicationVariant it) {
                ApplicationVariant applicationVariant = it;
                Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"it");
                String string = applicationVariant.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                String string2 = it.getFlavorName();
                BuildType buildType = it.getBuildType();
                Intrinsics.checkNotNullExpressionValue((Object)buildType, (String)"it.buildType");
                return SentryPluginUtils.INSTANCE.isVariantAllowed(this.$extension, string, string2, buildType.getName());
            }
            {
                this.$extension = sentryPluginExtension;
            }
        }).configureEach(new Action($this$configure, project, extension, cliExecutable, sentryOrg, sentryProject){
            final /* synthetic */ AppExtension $this_configure;
            final /* synthetic */ Project $project;
            final /* synthetic */ SentryPluginExtension $extension;
            final /* synthetic */ String $cliExecutable;
            final /* synthetic */ String $sentryOrg;
            final /* synthetic */ String $sentryProject;

            public final void execute(ApplicationVariant variant) {
                Object[] objectArray = new TaskProvider[3];
                ApplicationVariant applicationVariant = variant;
                Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"variant");
                objectArray[0] = SentryTasksProvider.getMergeAssetsProvider(applicationVariant);
                org.gradle.api.logging.Logger logger2 = this.$project.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
                objectArray[1] = SentryPluginUtils.INSTANCE.withLogging(logger2, "lintVitalAnalyzeTask", (Function0<? extends TaskProvider<Task>>)((Function0)new Function0<TaskProvider<Task>>(this, variant){
                    final /* synthetic */ configure.2 this$0;
                    final /* synthetic */ ApplicationVariant $variant;

                    @Nullable
                    public final TaskProvider<Task> invoke() {
                        Project project = this.this$0.$project;
                        ApplicationVariant applicationVariant = this.$variant;
                        Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"variant");
                        String string = applicationVariant.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                        return SentryTasksProvider.getLintVitalAnalyzeProvider(project, string);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$variant = applicationVariant;
                        super(0);
                    }
                }));
                org.gradle.api.logging.Logger logger3 = this.$project.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"project.logger");
                objectArray[2] = SentryPluginUtils.INSTANCE.withLogging(logger3, "lintVitalReportTask", (Function0<? extends TaskProvider<Task>>)((Function0)new Function0<TaskProvider<Task>>(this, variant){
                    final /* synthetic */ configure.2 this$0;
                    final /* synthetic */ ApplicationVariant $variant;

                    @Nullable
                    public final TaskProvider<Task> invoke() {
                        Project project = this.this$0.$project;
                        ApplicationVariant applicationVariant = this.$variant;
                        Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"variant");
                        String string = applicationVariant.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                        return SentryTasksProvider.getLintVitalReportProvider(project, string);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$variant = applicationVariant;
                        super(0);
                    }
                }));
                Set mergeAssetsDependants2 = SetsKt.setOf((Object[])objectArray);
                AppConfigKt.access$configureDependenciesTask((BaseVariant)variant, this.$project, this.$extension, this.$this_configure, mergeAssetsDependants2);
                AppConfigKt.access$configureProguardMappingsTasks(variant, this.$project, this.$extension, this.$this_configure, mergeAssetsDependants2, this.$cliExecutable, this.$sentryOrg, this.$sentryProject);
                AppConfigKt.access$configureNativeSymbolsTask(variant, this.$project, this.$extension, this.$cliExecutable, this.$sentryOrg, this.$sentryProject);
            }
            {
                this.$this_configure = appExtension;
                this.$project = project;
                this.$extension = sentryPluginExtension;
                this.$cliExecutable = string;
                this.$sentryOrg = string2;
                this.$sentryProject = string3;
            }
        });
    }

    private static final void configureDependenciesTask(BaseVariant $this$configureDependenciesTask, Project project, SentryPluginExtension extension, AppExtension appExtension, Set<? extends TaskProvider<? extends Task>> dependants) {
        if (AgpVersions.INSTANCE.isAGP74()) {
            org.gradle.api.logging.Logger logger2 = project.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
            SentryLoggingKt.info$default((Logger)logger2, null, configureDependenciesTask.1.INSTANCE, 1, null);
        } else {
            Object object = extension.getIncludeDependenciesReport().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.includeDependenciesReport.get()");
            if (((Boolean)object).booleanValue()) {
                ProjectLayout projectLayout = project.getLayout();
                Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
                Provider outputDir = projectLayout.getBuildDirectory().dir("generated" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + "assets" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + "sentry" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + "dependencies" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + $this$configureDependenciesTask.getName());
                String string = $this$configureDependenciesTask.getName() + "RuntimeClasspath";
                Provider provider = (Provider)extension.getIncludeDependenciesReport();
                String string2 = $this$configureDependenciesTask.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                TaskProvider<? extends DirectoryOutputTask> reportDependenciesTask = SentryExternalDependenciesReportTaskFactory.INSTANCE.register(project, string, "android-classes", (Provider<Boolean>)provider, (Provider<Directory>)outputDir, SentryTasksProvider.INSTANCE.getCapitalized$sentry_android_gradle_plugin(string2));
                AppConfigKt.setupMergeAssetsDependencies(reportDependenciesTask, dependants);
                AndroidSourceDirectorySet androidSourceDirectorySet = ((AndroidSourceSet)appExtension.getSourceSets().getByName($this$configureDependenciesTask.getName())).getAssets();
                Provider provider2 = reportDependenciesTask.flatMap((Transformer)configureDependenciesTask.2.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"reportDependenciesTask.flatMap { it.output }");
                androidSourceDirectorySet.srcDir((Object)provider2);
            }
        }
    }

    private static final void configureProguardMappingsTasks(ApplicationVariant $this$configureProguardMappingsTasks, Project project, SentryPluginExtension extension, AppExtension appExtension, Set<? extends TaskProvider<? extends Task>> dependants, String cliExecutable, String sentryOrg, String sentryProject) {
        if (AgpVersions.INSTANCE.isAGP74()) {
            org.gradle.api.logging.Logger logger2 = project.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
            SentryLoggingKt.info$default((Logger)logger2, null, configureProguardMappingsTasks.1.INSTANCE, 1, null);
        } else {
            AndroidVariant70 variant = new AndroidVariant70($this$configureProguardMappingsTasks);
            String sentryProps = SentryPropertiesFileProvider.getPropertiesFilePath(project, variant);
            Boolean guardsquareEnabled = (Boolean)extension.getExperimentalGuardsquareSupport().get();
            AndroidVariant androidVariant = variant;
            Boolean bl = guardsquareEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"guardsquareEnabled");
            boolean isMinifyEnabled = SentryPluginUtils.INSTANCE.isMinificationEnabled(project, androidVariant, bl);
            ProjectLayout projectLayout = project.getLayout();
            Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
            Provider outputDir = projectLayout.getBuildDirectory().dir("generated" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + "assets" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + "sentry" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + "proguard" + SentryPlugin.Companion.getSep$sentry_android_gradle_plugin() + $this$configureProguardMappingsTasks.getName());
            if (isMinifyEnabled) {
                Object object = extension.getIncludeProguardMapping().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.includeProguardMapping.get()");
                if (((Boolean)object).booleanValue()) {
                    String string = $this$configureProguardMappingsTasks.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    TaskProvider<SentryGenerateProguardUuidTask> generateUuidTask2 = SentryGenerateProguardUuidTask.Companion.register(project, (Provider<Directory>)outputDir, SentryTasksProvider.INSTANCE.getCapitalized$sentry_android_gradle_plugin(string));
                    AppConfigKt.setupMergeAssetsDependencies(generateUuidTask2, dependants);
                    TasksKt.hookWithPackageTasks(generateUuidTask2, project, variant);
                    AndroidSourceDirectorySet androidSourceDirectorySet = ((AndroidSourceSet)appExtension.getSourceSets().getByName($this$configureProguardMappingsTasks.getName())).getAssets();
                    Provider provider = generateUuidTask2.flatMap((Transformer)configureProguardMappingsTasks.2.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"generateUuidTask.flatMap { it.output }");
                    androidSourceDirectorySet.srcDir((Object)provider);
                    Provider provider2 = (Provider)generateUuidTask2;
                    Provider<FileCollection> provider3 = SentryTasksProvider.getMappingFileProvider(project, variant, guardsquareEnabled);
                    Property<Boolean> property = extension.getAutoUploadProguardMapping();
                    String string2 = $this$configureProguardMappingsTasks.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                    String string3 = SentryTasksProvider.INSTANCE.getCapitalized$sentry_android_gradle_plugin(string2);
                    String string4 = sentryProject;
                    String string5 = sentryOrg;
                    Property<Boolean> property2 = property;
                    Provider<FileCollection> provider4 = provider3;
                    String string6 = sentryProps;
                    Provider provider5 = provider2;
                    TaskProvider<SentryUploadProguardMappingsTask> uploadMappingsTask = SentryUploadProguardMappingsTask.Companion.register(project, cliExecutable, string6, (Provider<SentryGenerateProguardUuidTask>)provider5, provider4, string5, string4, property2, string3);
                    String string7 = $this$configureProguardMappingsTasks.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"name");
                    TasksKt.hookWithMinifyTasks(uploadMappingsTask, project, string7, guardsquareEnabled);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void configureNativeSymbolsTask(ApplicationVariant $this$configureNativeSymbolsTask, Project project, SentryPluginExtension extension, String cliExecutable, String sentryOrg, String sentryProject) {
        if (!$this$configureNativeSymbolsTask.getBuildType().isDebuggable()) {
            Object object = extension.getUploadNativeSymbols().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.uploadNativeSymbols.get()");
            if (((Boolean)object).booleanValue()) {
                TaskProvider uploadSentryNativeSymbolsTask2;
                AndroidVariant70 variant = new AndroidVariant70($this$configureNativeSymbolsTask);
                String sentryProps = SentryPropertiesFileProvider.getPropertiesFilePath(project, variant);
                TaskContainer taskContainer = project.getTasks();
                String string = $this$configureNativeSymbolsTask.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                TaskProvider taskProvider = uploadSentryNativeSymbolsTask2 = taskContainer.register("uploadSentryNativeSymbolsFor" + SentryTasksProvider.INSTANCE.getCapitalized$sentry_android_gradle_plugin(string), SentryUploadNativeSymbolsTask.class, new Action($this$configureNativeSymbolsTask, project, extension, cliExecutable, sentryProps, sentryOrg, sentryProject){
                    final /* synthetic */ ApplicationVariant $this_configureNativeSymbolsTask;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ SentryPluginExtension $extension;
                    final /* synthetic */ String $cliExecutable;
                    final /* synthetic */ String $sentryProps;
                    final /* synthetic */ String $sentryOrg;
                    final /* synthetic */ String $sentryProject;

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(SentryUploadNativeSymbolsTask it) {
                        File file;
                        it.workingDir(this.$project.getRootDir());
                        it.getAutoUploadNativeSymbol().set((Provider)this.$extension.getAutoUploadNativeSymbols());
                        it.getCliExecutable().set((Object)this.$cliExecutable);
                        RegularFileProperty regularFileProperty = it.getSentryProperties();
                        String string = this.$sentryProps;
                        if (string != null) {
                            void file2;
                            String string2;
                            String string3 = string2 = string;
                            RegularFileProperty regularFileProperty2 = regularFileProperty;
                            boolean bl = false;
                            File file3 = this.$project.file((Object)file2);
                            regularFileProperty = regularFileProperty2;
                            file = file3;
                        } else {
                            file = null;
                        }
                        regularFileProperty.set(file);
                        it.getIncludeNativeSources().set((Provider)this.$extension.getIncludeNativeSources());
                        it.getVariantName().set((Object)this.$this_configureNativeSymbolsTask.getName());
                        it.getSentryOrganization().set((Object)this.$sentryOrg);
                        it.getSentryProject().set((Object)this.$sentryProject);
                    }
                    {
                        this.$this_configureNativeSymbolsTask = applicationVariant;
                        this.$project = project;
                        this.$extension = sentryPluginExtension;
                        this.$cliExecutable = string;
                        this.$sentryProps = string2;
                        this.$sentryOrg = string3;
                        this.$sentryProject = string4;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"uploadSentryNativeSymbolsTask");
                TasksKt.hookWithAssembleTasks((TaskProvider<? extends Task>)taskProvider, project, variant);
                return;
            }
        }
        org.gradle.api.logging.Logger logger2 = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
        SentryLoggingKt.info$default((Logger)logger2, null, configureNativeSymbolsTask.1.INSTANCE, 1, null);
    }

    private static final void setupMergeAssetsDependencies(TaskProvider<? extends Task> $this$setupMergeAssetsDependencies, Set<? extends TaskProvider<? extends Task>> dependants) {
        Iterable $this$forEach$iv = dependants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskProvider it = (TaskProvider)element$iv;
            boolean bl = false;
            TaskProvider taskProvider = it;
            if (taskProvider == null) continue;
            taskProvider.configure(new Action($this$setupMergeAssetsDependencies){
                final /* synthetic */ TaskProvider $this_setupMergeAssetsDependencies$inlined;
                {
                    this.$this_setupMergeAssetsDependencies$inlined = taskProvider;
                }

                public final void execute(Task task) {
                    task.dependsOn(new Object[]{this.$this_setupMergeAssetsDependencies$inlined});
                }
            });
        }
    }

    public static final /* synthetic */ void access$configureDependenciesTask(BaseVariant $this$access_u24configureDependenciesTask, Project project, SentryPluginExtension extension, AppExtension appExtension, Set dependants) {
        AppConfigKt.configureDependenciesTask($this$access_u24configureDependenciesTask, project, extension, appExtension, dependants);
    }

    public static final /* synthetic */ void access$configureProguardMappingsTasks(ApplicationVariant $this$access_u24configureProguardMappingsTasks, Project project, SentryPluginExtension extension, AppExtension appExtension, Set dependants, String cliExecutable, String sentryOrg, String sentryProject) {
        AppConfigKt.configureProguardMappingsTasks($this$access_u24configureProguardMappingsTasks, project, extension, appExtension, dependants, cliExecutable, sentryOrg, sentryProject);
    }

    public static final /* synthetic */ void access$configureNativeSymbolsTask(ApplicationVariant $this$access_u24configureNativeSymbolsTask, Project project, SentryPluginExtension extension, String cliExecutable, String sentryOrg, String sentryProject) {
        AppConfigKt.configureNativeSymbolsTask($this$access_u24configureNativeSymbolsTask, project, extension, cliExecutable, sentryOrg, sentryProject);
    }
}

