/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.tasks;

import io.sentry.android.gradle.tasks.SentryGenerateProguardUuidTask;
import io.sentry.android.gradle.tasks.SentryUploadProguardMappingsTask;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020 H\u0014J\r\u0010!\u001a\u00020 H\u0000\u00a2\u0006\u0002\b\"R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006$"}, d2={"Lio/sentry/android/gradle/tasks/SentryUploadProguardMappingsTask;", "Lorg/gradle/api/tasks/Exec;", "()V", "autoUploadProguardMapping", "Lorg/gradle/api/provider/Property;", "", "getAutoUploadProguardMapping", "()Lorg/gradle/api/provider/Property;", "cliExecutable", "", "getCliExecutable", "mappingsFiles", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileCollection;", "getMappingsFiles", "()Lorg/gradle/api/provider/Provider;", "setMappingsFiles", "(Lorg/gradle/api/provider/Provider;)V", "sentryOrganization", "getSentryOrganization", "sentryProject", "getSentryProject", "sentryProperties", "Lorg/gradle/api/file/RegularFileProperty;", "getSentryProperties", "()Lorg/gradle/api/file/RegularFileProperty;", "uuidFile", "getUuidFile", "computeCommandLineArgs", "", "computeCommandLineArgs$sentry_android_gradle_plugin", "exec", "", "setSentryPropertiesEnv", "setSentryPropertiesEnv$sentry_android_gradle_plugin", "Companion", "sentry-android-gradle-plugin"})
public abstract class SentryUploadProguardMappingsTask
extends Exec {
    private static final String PROPERTY_PREFIX = "io.sentry.ProguardUuids=";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract Property<String> getCliExecutable();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getUuidFile();

    @InputFiles
    @NotNull
    public abstract Provider<FileCollection> getMappingsFiles();

    public abstract void setMappingsFiles(@NotNull Provider<FileCollection> var1);

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getSentryProperties();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSentryOrganization();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSentryProject();

    @Input
    @NotNull
    public abstract Property<Boolean> getAutoUploadProguardMapping();

    protected void exec() {
        List<String> list;
        block3: {
            block2: {
                if (!this.getMappingsFiles().isPresent()) break block2;
                Object object = this.getMappingsFiles().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mappingsFiles.get()");
                if (!((FileCollection)object).isEmpty()) break block3;
            }
            String string = "[sentry] Mapping files are missing!";
            throw new IllegalStateException(string.toString());
        }
        List<String> it = list = this.computeCommandLineArgs$sentry_android_gradle_plugin();
        boolean bl = false;
        this.commandLine(it);
        this.getLogger().info("cli args: " + it);
        this.setSentryPropertiesEnv$sentry_android_gradle_plugin();
        super.exec();
    }

    public final void setSentryPropertiesEnv$sentry_android_gradle_plugin() {
        RegularFile sentryProperties = (RegularFile)this.getSentryProperties().getOrNull();
        if (sentryProperties != null) {
            this.environment("SENTRY_PROPERTIES", sentryProperties);
        } else {
            this.getLogger().info("propsFile is null");
        }
    }

    @NotNull
    public final List<String> computeCommandLineArgs$sentry_android_gradle_plugin() {
        Object it;
        File file;
        Object v4;
        Object object;
        String uuid;
        block7: {
            Object object2 = this.getUuidFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"uuidFile.get()");
            File file2 = ((RegularFile)object2).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"uuidFile.get().asFile");
            uuid = Companion.readUuidFromFile$sentry_android_gradle_plugin(file2);
            Object object3 = this.getMappingsFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mappingsFiles.get()");
            Set set = ((FileCollection)object3).getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"mappingsFiles.get().files");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                File it2 = (File)element$iv;
                boolean bl = false;
                if (!it2.exists()) continue;
                v4 = element$iv;
                break block7;
            }
            v4 = null;
        }
        File firstExistingFile = v4;
        if (firstExistingFile == null) {
            this.getLogger().warn("None of the provided mappingFiles was found on disk. Upload is most likely going to be skipped");
            Object object4 = this.getMappingsFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"mappingsFiles.get()");
            Set set = ((FileCollection)object4).getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"mappingsFiles.get().files");
            file = (File)CollectionsKt.first((Iterable)set);
        } else {
            file = firstExistingFile;
        }
        File mappingFile = file;
        List args = CollectionsKt.mutableListOf((Object[])new String[]{(String)this.getCliExecutable().get(), "upload-proguard", "--uuid", uuid, mappingFile.toString()});
        if (!((Boolean)this.getAutoUploadProguardMapping().get()).booleanValue()) {
            args.add("--no-upload");
        }
        String string = (String)this.getSentryOrganization().getOrNull();
        if (string != null) {
            it = object = string;
            boolean bl = false;
            args.add("--org");
            args.add(it);
        }
        String string2 = (String)this.getSentryProject().getOrNull();
        if (string2 != null) {
            it = object = string2;
            boolean bl = false;
            args.add("--project");
            args.add(it);
        }
        if (Os.isFamily((String)"windows")) {
            args.add(0, "cmd");
            args.add(1, "/c");
        }
        return args;
    }

    public SentryUploadProguardMappingsTask() {
        this.setDescription("Uploads the proguard mappings file to Sentry");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJn\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/sentry/android/gradle/tasks/SentryUploadProguardMappingsTask$Companion;", "", "()V", "PROPERTY_PREFIX", "", "readUuidFromFile", "file", "Ljava/io/File;", "readUuidFromFile$sentry_android_gradle_plugin", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/sentry/android/gradle/tasks/SentryUploadProguardMappingsTask;", "project", "Lorg/gradle/api/Project;", "cliExecutable", "sentryProperties", "generateUuidTask", "Lorg/gradle/api/provider/Provider;", "Lio/sentry/android/gradle/tasks/SentryGenerateProguardUuidTask;", "mappingFiles", "Lorg/gradle/api/file/FileCollection;", "sentryOrg", "sentryProject", "autoUploadProguardMapping", "Lorg/gradle/api/provider/Property;", "", "taskSuffix", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String readUuidFromFile$sentry_android_gradle_plugin(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean bl = file.exists();
            if (!bl) {
                boolean bl2 = false;
                String string = "UUID properties file is missing";
                throw new IllegalStateException(string.toString());
            }
            String string = FilesKt.readText$default((File)file, null, (int)1, null);
            String content = ((Object)StringsKt.trim((CharSequence)string)).toString();
            boolean bl3 = StringsKt.startsWith$default((String)content, (String)SentryUploadProguardMappingsTask.PROPERTY_PREFIX, (boolean)false, (int)2, null);
            if (!bl3) {
                boolean bl4 = false;
                String string2 = "io.sentry.ProguardUuids property is missing";
                throw new IllegalStateException(string2.toString());
            }
            return StringsKt.removePrefix((String)content, (CharSequence)SentryUploadProguardMappingsTask.PROPERTY_PREFIX);
        }

        @NotNull
        public final TaskProvider<SentryUploadProguardMappingsTask> register(@NotNull Project project, @NotNull String cliExecutable, @Nullable String sentryProperties, @NotNull Provider<SentryGenerateProguardUuidTask> generateUuidTask2, @NotNull Provider<FileCollection> mappingFiles, @Nullable String sentryOrg, @Nullable String sentryProject, @NotNull Property<Boolean> autoUploadProguardMapping, @NotNull String taskSuffix) {
            TaskProvider uploadSentryProguardMappingsTask2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cliExecutable, (String)"cliExecutable");
            Intrinsics.checkNotNullParameter(generateUuidTask2, (String)"generateUuidTask");
            Intrinsics.checkNotNullParameter(mappingFiles, (String)"mappingFiles");
            Intrinsics.checkNotNullParameter(autoUploadProguardMapping, (String)"autoUploadProguardMapping");
            Intrinsics.checkNotNullParameter((Object)taskSuffix, (String)"taskSuffix");
            TaskProvider taskProvider = uploadSentryProguardMappingsTask2 = project.getTasks().register("uploadSentryProguardMappings" + taskSuffix, SentryUploadProguardMappingsTask.class, new Action(generateUuidTask2, project, cliExecutable, sentryProperties, mappingFiles, autoUploadProguardMapping, sentryOrg, sentryProject){
                final /* synthetic */ Provider $generateUuidTask;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $cliExecutable;
                final /* synthetic */ String $sentryProperties;
                final /* synthetic */ Provider $mappingFiles;
                final /* synthetic */ Property $autoUploadProguardMapping;
                final /* synthetic */ String $sentryOrg;
                final /* synthetic */ String $sentryProject;

                /*
                 * WARNING - void declaration
                 */
                public final void execute(SentryUploadProguardMappingsTask task) {
                    File file;
                    task.dependsOn(new Object[]{this.$generateUuidTask});
                    task.workingDir(this.$project.getRootDir());
                    task.getCliExecutable().set((Object)this.$cliExecutable);
                    RegularFileProperty regularFileProperty = task.getSentryProperties();
                    String string = this.$sentryProperties;
                    if (string != null) {
                        void file2;
                        String string2;
                        String string3 = string2 = string;
                        RegularFileProperty regularFileProperty2 = regularFileProperty;
                        boolean bl = false;
                        File file3 = this.$project.file((Object)file2);
                        regularFileProperty = regularFileProperty2;
                        file = file3;
                    } else {
                        file = null;
                    }
                    regularFileProperty.set(file);
                    task.getUuidFile().set(this.$generateUuidTask.flatMap((Transformer)register.uploadSentryProguardMappingsTask.2.INSTANCE));
                    task.setMappingsFiles((Provider<FileCollection>)this.$mappingFiles);
                    task.getAutoUploadProguardMapping().set((Provider)this.$autoUploadProguardMapping);
                    task.getSentryOrganization().set((Object)this.$sentryOrg);
                    task.getSentryProject().set((Object)this.$sentryProject);
                }
                {
                    this.$generateUuidTask = provider;
                    this.$project = project;
                    this.$cliExecutable = string;
                    this.$sentryProperties = string2;
                    this.$mappingFiles = provider2;
                    this.$autoUploadProguardMapping = property;
                    this.$sentryOrg = string3;
                    this.$sentryProject = string4;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"uploadSentryProguardMappingsTask");
            return taskProvider;
        }

        public static /* synthetic */ TaskProvider register$default(Companion companion, Project project, String string, String string2, Provider provider, Provider provider2, String string3, String string4, Property property, String string5, int n, Object object) {
            if ((n & 0x100) != 0) {
                string5 = "";
            }
            return companion.register(project, string, string2, (Provider<SentryGenerateProguardUuidTask>)provider, (Provider<FileCollection>)provider2, string3, string4, (Property<Boolean>)property, string5);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

